/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.comm.io.FixedLengthInputStream;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.WebServiceRequest;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class OSSRequestMessageBuilder {
    private URI endpoint;
    private HttpMethod method = HttpMethod.GET;
    private String bucket;
    private String key;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private InputStream inputStream;
    private long inputSize = 0L;
    private ServiceClient innerClient;
    private boolean useChunkEncoding = false;
    private WebServiceRequest originalRequest;

    public OSSRequestMessageBuilder(ServiceClient innerClient) {
        this.innerClient = innerClient;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public OSSRequestMessageBuilder setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public OSSRequestMessageBuilder setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public String getBucket() {
        return this.bucket;
    }

    public OSSRequestMessageBuilder setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public OSSRequestMessageBuilder setKey(String key) {
        this.key = key;
        return this;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public OSSRequestMessageBuilder setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public OSSRequestMessageBuilder addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public OSSRequestMessageBuilder setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public OSSRequestMessageBuilder addParameter(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OSSRequestMessageBuilder setInputStream(InputStream instream) {
        this.inputStream = instream;
        return this;
    }

    public OSSRequestMessageBuilder setInputStreamWithLength(FixedLengthInputStream instream) {
        CodingUtils.assertParameterInRange(this.inputSize, -1L, 0x140000000L);
        this.inputStream = instream;
        this.inputSize = instream.getLength();
        return this;
    }

    public long getInputSize() {
        return this.inputSize;
    }

    public OSSRequestMessageBuilder setInputSize(long inputSize) {
        CodingUtils.assertParameterInRange(inputSize, -1L, 0x140000000L);
        this.inputSize = inputSize;
        return this;
    }

    public boolean isUseChunkEncoding() {
        return this.useChunkEncoding;
    }

    public OSSRequestMessageBuilder setUseChunkEncoding(boolean useChunkEncoding) {
        this.useChunkEncoding = useChunkEncoding;
        return this;
    }

    public OSSRequestMessageBuilder setOriginalRequest(WebServiceRequest originalRequest) {
        this.originalRequest = originalRequest;
        return this;
    }

    public RequestMessage build() {
        HashMap<String, String> sentHeaders = new HashMap<String, String>(this.headers);
        sentHeaders.put("Date", DateUtil.formatRfc822Date(new Date()));
        LinkedHashMap<String, String> sentParameters = new LinkedHashMap<String, String>(this.parameters);
        RequestMessage request = new RequestMessage(this.originalRequest);
        ClientConfiguration clientCofig = this.innerClient.getClientConfiguration();
        request.setEndpoint(OSSUtils.determineFinalEndpoint(this.endpoint, this.bucket, clientCofig));
        request.setResourcePath(OSSUtils.determineResourcePath(this.bucket, this.key, clientCofig.isSLDEnabled()));
        request.setHeaders(sentHeaders);
        request.setParameters(sentParameters);
        request.setMethod(this.method);
        request.setContent(this.inputStream);
        request.setContentLength(this.inputSize);
        request.setUseChunkEncoding(this.inputSize == -1L ? true : this.useChunkEncoding);
        return request;
    }
}

