/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.internal.utils.ObjectUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.StorageClassEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LifecycleConfiguration
extends HeaderResponse {
    private List<Rule> rules;

    public LifecycleConfiguration(List<Rule> rules) {
        this.rules = rules;
    }

    public LifecycleConfiguration() {
    }

    public List<Rule> getRules() {
        if (this.rules == null) {
            this.rules = new ArrayList<Rule>();
        }
        return this.rules;
    }

    public void addRule(Rule rule) {
        if (!this.getRules().contains(rule)) {
            this.getRules().add(rule);
        }
    }

    public Rule newRule(String id, String prefix, Boolean enabled) {
        Rule rule = new Rule(id, prefix, enabled);
        this.getRules().add(rule);
        return rule;
    }

    public static void setDays(TimeEvent timeEvent, Integer days) {
        if (timeEvent != null) {
            timeEvent.days = days;
        }
    }

    public static void setDate(TimeEvent timeEvent, Date date) {
        if (timeEvent != null) {
            timeEvent.date = date;
        }
    }

    public static void setStorageClass(TimeEvent timeEvent, StorageClassEnum storageClass) {
        if (timeEvent != null) {
            timeEvent.storageClass = storageClass;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LifecycleConfiguration that = (LifecycleConfiguration)o;
        return !(this.rules != null ? !this.rules.equals(that.rules) : that.rules != null);
    }

    public int hashCode() {
        return this.rules != null ? this.rules.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "LifecycleConfiguration [rules=" + this.rules + "]";
    }

    public class Rule {
        protected String id;
        protected String prefix;
        protected Boolean enabled;
        protected Expiration expiration;
        protected NoncurrentVersionExpiration noncurrentVersionExpiration;
        protected List<Transition> transitions;
        protected List<NoncurrentVersionTransition> noncurrentVersionTransitions;

        public Rule() {
        }

        public Rule(String id, String prefix, Boolean enabled) {
            this.id = id;
            this.prefix = prefix;
            this.enabled = enabled;
        }

        public Expiration newExpiration() {
            this.expiration = new Expiration();
            return this.expiration;
        }

        public NoncurrentVersionExpiration newNoncurrentVersionExpiration() {
            this.noncurrentVersionExpiration = new NoncurrentVersionExpiration();
            return this.noncurrentVersionExpiration;
        }

        public Transition newTransition() {
            if (this.transitions == null) {
                this.transitions = new ArrayList<Transition>();
            }
            Transition t = new Transition();
            this.transitions.add(t);
            return t;
        }

        public NoncurrentVersionTransition newNoncurrentVersionTransition() {
            if (this.noncurrentVersionTransitions == null) {
                this.noncurrentVersionTransitions = new ArrayList<NoncurrentVersionTransition>();
            }
            NoncurrentVersionTransition nt = new NoncurrentVersionTransition();
            this.noncurrentVersionTransitions.add(nt);
            return nt;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Expiration getExpiration() {
            return this.expiration;
        }

        public void setExpiration(Expiration expiration) {
            this.expiration = expiration;
        }

        public NoncurrentVersionExpiration getNoncurrentVersionExpiration() {
            return this.noncurrentVersionExpiration;
        }

        public void setNoncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
        }

        public List<Transition> getTransitions() {
            if (this.transitions == null) {
                this.transitions = new ArrayList<Transition>();
            }
            return this.transitions;
        }

        public void setTransitions(List<Transition> transitions) {
            this.transitions = transitions;
        }

        public List<NoncurrentVersionTransition> getNoncurrentVersionTransitions() {
            if (this.noncurrentVersionTransitions == null) {
                this.noncurrentVersionTransitions = new ArrayList<NoncurrentVersionTransition>();
            }
            return this.noncurrentVersionTransitions;
        }

        public void setNoncurrentVersionTransitions(List<NoncurrentVersionTransition> noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions = noncurrentVersionTransitions;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
            result = 31 * result + (this.expiration == null ? 0 : this.expiration.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.noncurrentVersionExpiration == null ? 0 : this.noncurrentVersionExpiration.hashCode());
            result = 31 * result + (this.noncurrentVersionTransitions == null ? 0 : this.noncurrentVersionTransitions.hashCode());
            result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
            result = 31 * result + (this.transitions == null ? 0 : this.transitions.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Rule other = (Rule)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (!ObjectUtils.isEquals(this.enabled, other.enabled)) {
                return false;
            }
            if (!ObjectUtils.isEquals(this.expiration, other.expiration)) {
                return false;
            }
            if (!ObjectUtils.isEquals(this.id, other.id)) {
                return false;
            }
            if (!ObjectUtils.isEquals(this.noncurrentVersionExpiration, other.noncurrentVersionExpiration)) {
                return false;
            }
            if (!ObjectUtils.isEquals(this.noncurrentVersionTransitions, other.noncurrentVersionTransitions)) {
                return false;
            }
            if (!ObjectUtils.isEquals(this.prefix, other.prefix)) {
                return false;
            }
            return ObjectUtils.isEquals(this.transitions, other.transitions);
        }

        public String toString() {
            return "Rule [id=" + this.id + ", prefix=" + this.prefix + ", enabled=" + this.enabled + ", expiration=" + this.expiration + ", noncurrentVersionExpiration=" + this.noncurrentVersionExpiration + ", transitions=" + this.transitions + ", noncurrentVersionTransitions=" + this.noncurrentVersionTransitions + "]";
        }

        private LifecycleConfiguration getOuterType() {
            return LifecycleConfiguration.this;
        }
    }

    public class NoncurrentVersionTransition
    extends TimeEvent {
        public NoncurrentVersionTransition() {
        }

        @Deprecated
        public NoncurrentVersionTransition(Integer days, String storageClass) {
            this.days = days;
            this.storageClass = StorageClassEnum.getValueFromCode(storageClass);
        }

        public NoncurrentVersionTransition(Integer days, StorageClassEnum storageClass) {
            this.days = days;
            this.storageClass = storageClass;
        }

        public Integer getDays() {
            return this.days;
        }

        public void setDays(Integer days) {
            this.days = days;
        }

        @Deprecated
        public String getStorageClass() {
            return this.storageClass != null ? this.storageClass.getCode() : null;
        }

        @Deprecated
        public void setStorageClass(String storageClass) {
            this.storageClass = StorageClassEnum.getValueFromCode(storageClass);
        }

        public StorageClassEnum getObjectStorageClass() {
            return this.storageClass;
        }

        public void setObjectStorageClass(StorageClassEnum storageClass) {
            this.storageClass = storageClass;
        }

        public String toString() {
            return "NoncurrentVersionTransition [days=" + this.days + ", storageClass=" + (Object)((Object)this.storageClass) + "]";
        }
    }

    public class Transition
    extends TimeEvent {
        public Transition() {
        }

        @Deprecated
        public Transition(Date date, String storageClass) {
            super(date);
            this.storageClass = StorageClassEnum.getValueFromCode(storageClass);
        }

        public Transition(Date date, StorageClassEnum storageClass) {
            super(date);
            this.storageClass = storageClass;
        }

        @Deprecated
        public Transition(Integer days, String storageClass) {
            super(days);
            this.storageClass = StorageClassEnum.getValueFromCode(storageClass);
        }

        public Transition(Integer days, StorageClassEnum storageClass) {
            super(days);
            this.storageClass = storageClass;
        }

        @Deprecated
        public String getStorageClass() {
            return this.storageClass != null ? this.storageClass.getCode() : null;
        }

        @Deprecated
        public void setStorageClass(String storageClass) {
            this.storageClass = StorageClassEnum.getValueFromCode(storageClass);
        }

        public StorageClassEnum getObjectStorageClass() {
            return this.storageClass;
        }

        public void setObjectStorageClass(StorageClassEnum storageClass) {
            this.storageClass = storageClass;
        }

        public Integer getDays() {
            return this.days;
        }

        public void setDays(Integer days) {
            this.days = days;
            this.date = null;
        }

        public Date getDate() {
            return ServiceUtils.cloneDateIgnoreNull(this.date);
        }

        public void setDate(Date date) {
            this.date = ServiceUtils.cloneDateIgnoreNull(date);
            this.days = null;
        }

        public String toString() {
            return "Transition [days=" + this.days + ", date=" + this.date + ", storageClass=" + (Object)((Object)this.storageClass) + "]";
        }
    }

    public class Expiration
    extends TimeEvent {
        public Expiration() {
        }

        public Expiration(Date date) {
            super(date);
        }

        public Expiration(Integer days) {
            super(days);
        }

        public Integer getDays() {
            return this.days;
        }

        public void setDays(Integer days) {
            this.days = days;
            this.date = null;
        }

        public Date getDate() {
            return ServiceUtils.cloneDateIgnoreNull(this.date);
        }

        public void setDate(Date date) {
            this.date = ServiceUtils.cloneDateIgnoreNull(date);
            this.days = null;
        }

        public String toString() {
            return "Expiration [days=" + this.days + ", date=" + this.date + "]";
        }
    }

    public class NoncurrentVersionExpiration
    extends TimeEvent {
        public NoncurrentVersionExpiration() {
        }

        public NoncurrentVersionExpiration(Integer days) {
            this.days = days;
        }

        public Integer getDays() {
            return this.days;
        }

        public void setDays(Integer days) {
            this.days = days;
        }

        public String toString() {
            return "NoncurrentVersionExpiration [days=" + this.days + "]";
        }
    }

    public abstract class TimeEvent {
        protected Integer days;
        protected Date date;
        protected StorageClassEnum storageClass;

        public TimeEvent() {
        }

        protected TimeEvent(Integer days) {
            this.days = days;
        }

        protected TimeEvent(Date date) {
            this.date = date;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
            result = 31 * result + (this.days == null ? 0 : this.days.hashCode());
            result = 31 * result + (this.storageClass == null ? 0 : this.storageClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeEvent other = (TimeEvent)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
                return false;
            }
            if (this.days == null ? other.days != null : !this.days.equals(other.days)) {
                return false;
            }
            return this.storageClass == other.storageClass;
        }

        private LifecycleConfiguration getOuterType() {
            return LifecycleConfiguration.this;
        }
    }
}

