/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.impl.conn;

import com.pingan.iobs.sdk.repkg.org.apache.http.annotation.ThreadSafe;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.ManagedHttpClientConnection;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.routing.HttpRoute;
import com.pingan.iobs.sdk.repkg.org.apache.http.impl.conn.CPoolEntry;
import com.pingan.iobs.sdk.repkg.org.apache.http.pool.AbstractConnPool;
import com.pingan.iobs.sdk.repkg.org.apache.http.pool.ConnFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
class CPool
extends AbstractConnPool<HttpRoute, ManagedHttpClientConnection, CPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final long timeToLive;
    private final TimeUnit tunit;

    public CPool(ConnFactory<HttpRoute, ManagedHttpClientConnection> connFactory, int defaultMaxPerRoute, int maxTotal, long timeToLive, TimeUnit tunit) {
        super(connFactory, defaultMaxPerRoute, maxTotal);
        this.timeToLive = timeToLive;
        this.tunit = tunit;
    }

    @Override
    protected CPoolEntry createEntry(HttpRoute route, ManagedHttpClientConnection conn) {
        String id = Long.toString(COUNTER.getAndIncrement());
        return new CPoolEntry(id, route, conn, this.timeToLive, this.tunit);
    }
}

