/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.impl.cookie;

import com.pingan.iobs.sdk.repkg.org.apache.http.annotation.Immutable;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.ClientCookie;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.Cookie;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.CookieAttributeHandler;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.CookieOrigin;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.CookieRestrictionViolationException;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.MalformedCookieException;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.SetCookie;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.SetCookie2;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.Args;

@Immutable
public class RFC2965VersionAttributeHandler
implements CookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }
}

