/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.bean;

import com.xiaoleilu.hutool.lang.Assert;
import com.xiaoleilu.hutool.map.CaseInsensitiveMap;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.ReflectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import com.xiaoleilu.hutool.util.TypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BeanDesc {
    private Class<?> beanClass;
    private Map<String, PropDesc> propMap = new HashMap<String, PropDesc>();

    public BeanDesc(Class<?> beanClass) {
        Assert.notNull(beanClass);
        this.beanClass = beanClass;
        this.init();
    }

    public String getName() {
        return this.beanClass.getName();
    }

    public String getSimpleName() {
        return this.beanClass.getSimpleName();
    }

    public Map<String, PropDesc> getPropMap(boolean ignoreCase) {
        return ignoreCase ? new CaseInsensitiveMap<String, PropDesc>(1.0f, this.propMap) : this.propMap;
    }

    public Collection<PropDesc> getProps() {
        return this.propMap.values();
    }

    public PropDesc getProp(String fieldName) {
        return this.propMap.get(fieldName);
    }

    public Field getField(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getField();
    }

    public Method getGetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getGetter();
    }

    public Method getSetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getSetter();
    }

    private BeanDesc init() {
        Field[] fields;
        for (Field field : fields = ReflectUtil.getFields(this.beanClass)) {
            Method getter;
            String fieldName = field.getName();
            Class<?> fieldType = field.getType();
            if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
                String subFieldName = StrUtil.removePrefix(fieldName, "is");
                getter = ReflectUtil.getMethodIgnoreCase(this.beanClass, StrUtil.upperFirstAndAddPre(subFieldName, "is"), new Class[0]);
                if (null == getter) {
                    getter = ReflectUtil.getMethodIgnoreCase(this.beanClass, StrUtil.genGetter(subFieldName), new Class[0]);
                }
            } else {
                getter = ReflectUtil.getMethodIgnoreCase(this.beanClass, StrUtil.genGetter(fieldName), new Class[0]);
            }
            Method setter = ReflectUtil.getMethodIgnoreCase(this.beanClass, StrUtil.genSetter(fieldName), field.getType());
            this.propMap.put(fieldName, new PropDesc(field, getter, setter));
        }
        return this;
    }

    public static class PropDesc {
        private Field field;
        private Method getter;
        private Method setter;

        public PropDesc(Field field, Method getter, Method setter) {
            this.field = field;
            this.getter = ClassUtil.setAccessible(getter);
            this.setter = ClassUtil.setAccessible(setter);
        }

        public String getFieldName() {
            return null == this.field ? null : this.field.getName();
        }

        public Field getField() {
            return this.field;
        }

        public Type getFieldType() {
            if (null != this.field) {
                return TypeUtil.getType(this.field);
            }
            return this.findPropType(this.getter, this.setter);
        }

        public Class<?> getFieldClass() {
            if (null != this.field) {
                return TypeUtil.getClass(this.field);
            }
            return this.findPropClass(this.getter, this.setter);
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        private Type findPropType(Method getter, Method setter) {
            Type type = null;
            if (null != getter) {
                type = TypeUtil.getReturnType(getter);
            }
            if (null == type && null != setter) {
                type = TypeUtil.getParamType(setter, 0);
            }
            return type;
        }

        private Class<?> findPropClass(Method getter, Method setter) {
            Class<?> type = null;
            if (null != getter) {
                type = TypeUtil.getReturnClass(getter);
            }
            if (null == type && null != setter) {
                type = TypeUtil.getFirstParamClass(setter);
            }
            return type;
        }
    }
}

