/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds;

import com.xiaoleilu.hutool.db.ds.c3p0.C3p0DSFactory;
import com.xiaoleilu.hutool.db.ds.dbcp.DbcpDSFactory;
import com.xiaoleilu.hutool.db.ds.druid.DruidDSFactory;
import com.xiaoleilu.hutool.db.ds.hikari.HikariDSFactory;
import com.xiaoleilu.hutool.db.ds.pooled.PooledDSFactory;
import com.xiaoleilu.hutool.db.ds.tomcat.TomcatDSFactory;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import com.xiaoleilu.hutool.setting.Setting;
import javax.sql.DataSource;

public abstract class DSFactory {
    private static final Log log = LogFactory.get();
    protected static final String DEFAULT_DB_SETTING_PATH = "config/db.setting";
    protected static final String DEFAULT_DB_SETTING_PATH2 = "db.setting";
    public static final String[] KEY_ALIAS_URL = new String[]{"url", "jdbcUrl"};
    public static final String[] KEY_ALIAS_USER = new String[]{"user", "username"};
    public static final String[] KEY_ALIAS_PASSWORD = new String[]{"password", "pass"};
    public static final String[] KEY_ALIAS_DRIVER = new String[]{"driver", "driverClassName"};
    private String dataSourceName;
    protected Setting setting;
    private static DSFactory currentDSFactory;
    private static final Object lock;

    public DSFactory(String dataSourceName, Class<? extends DataSource> dataSourceClass, Setting setting) {
        this.dataSourceName = dataSourceName;
        if (null == setting) {
            try {
                setting = new Setting(DEFAULT_DB_SETTING_PATH, true);
            }
            catch (IORuntimeException e) {
                setting = new Setting(DEFAULT_DB_SETTING_PATH2, true);
            }
        }
        this.setting = setting;
    }

    public DataSource getDataSource() {
        return this.getDataSource("");
    }

    public abstract DataSource getDataSource(String var1);

    public void close() {
        this.close("");
    }

    public abstract void close(String var1);

    public abstract void destroy();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataSourceName == null ? 0 : this.dataSourceName.hashCode());
        result = 31 * result + (this.setting == null ? 0 : this.setting.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DSFactory other = (DSFactory)obj;
        if (this.dataSourceName == null ? other.dataSourceName != null : !this.dataSourceName.equals(other.dataSourceName)) {
            return false;
        }
        return !(this.setting == null ? other.setting != null : !this.setting.equals(other.setting));
    }

    public static DataSource get() {
        return DSFactory.get(null);
    }

    public static DataSource get(String group) {
        return DSFactory.get(null, group);
    }

    public static DataSource get(Setting dbSetting, String group) {
        return DSFactory.getCurrentDSFactory(dbSetting).getDataSource(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSFactory getCurrentDSFactory(Setting setting) {
        if (null == currentDSFactory) {
            Object object = lock;
            synchronized (object) {
                if (null == currentDSFactory) {
                    currentDSFactory = DSFactory.detectDSFactory(setting);
                }
            }
        }
        return currentDSFactory;
    }

    public static synchronized DSFactory setCurrentDSFactory(DSFactory dsFactory) {
        if (null != currentDSFactory) {
            if (currentDSFactory.equals(dsFactory)) {
                return currentDSFactory;
            }
            currentDSFactory.destroy();
        }
        log.debug("Custom use [{}] datasource.", dsFactory.dataSourceName);
        currentDSFactory = dsFactory;
        return currentDSFactory;
    }

    private static DSFactory detectDSFactory(Setting setting) {
        DSFactory dsFactory;
        try {
            dsFactory = new HikariDSFactory(setting);
        }
        catch (NoClassDefFoundError e1) {
            try {
                dsFactory = new DruidDSFactory(setting);
            }
            catch (NoClassDefFoundError e2) {
                try {
                    dsFactory = new TomcatDSFactory(setting);
                }
                catch (NoClassDefFoundError e3) {
                    try {
                        dsFactory = new DbcpDSFactory(setting);
                    }
                    catch (NoClassDefFoundError e4) {
                        try {
                            dsFactory = new C3p0DSFactory(setting);
                        }
                        catch (NoClassDefFoundError e5) {
                            dsFactory = new PooledDSFactory(setting);
                        }
                    }
                }
            }
        }
        log.debug("Use [{}] DataSource As Default", dsFactory.dataSourceName);
        return dsFactory;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (null != currentDSFactory) {
                    currentDSFactory.destroy();
                    log.debug("DataSource: [{}] destroyed.", currentDSFactory.dataSourceName);
                }
            }
        });
        lock = new Object();
    }
}

