/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.pooled;

import com.xiaoleilu.hutool.collection.CollectionUtil;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.db.ds.pooled.DbSetting;
import com.xiaoleilu.hutool.db.ds.pooled.PooledDataSource;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.setting.Setting;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class PooledDSFactory
extends DSFactory {
    public static final String DS_NAME = "Hutool-Pooled-DataSource";
    private Map<String, PooledDataSource> dsMap = new ConcurrentHashMap<String, PooledDataSource>();

    public PooledDSFactory() {
        this(null);
    }

    public PooledDSFactory(Setting setting) {
        super(DS_NAME, PooledDataSource.class, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        PooledDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        PooledDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        PooledDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            IoUtil.close(ds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<PooledDataSource> values = this.dsMap.values();
            for (PooledDataSource ds : values) {
                IoUtil.close(ds);
            }
            this.dsMap.clear();
        }
    }

    private PooledDataSource createDataSource(String group) {
        if (group == null) {
            group = "";
        }
        PooledDataSource ds = new PooledDataSource(new DbSetting(this.setting), group);
        return ds;
    }
}

