/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.http.Header;
import com.xiaoleilu.hutool.http.HttpBase;
import com.xiaoleilu.hutool.http.HttpConnection;
import com.xiaoleilu.hutool.http.HttpException;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.io.FastByteArrayOutputStream;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class HttpResponse
extends HttpBase<HttpResponse> {
    private HttpConnection httpConnection;
    private InputStream in;
    private volatile boolean isAsync;
    private FastByteArrayOutputStream out;
    private int status;
    private boolean ignoreBody;

    protected HttpResponse(HttpConnection httpConnection, Charset charset, boolean isAsync, boolean isIgnoreBody) {
        this.httpConnection = httpConnection;
        this.charset = charset;
        this.isAsync = isAsync;
        this.ignoreBody = isIgnoreBody;
        this.init();
    }

    public int getStatus() {
        return this.status;
    }

    public HttpResponse sync() throws HttpException {
        return this.isAsync ? this.forceSync() : this;
    }

    public String contentEncoding() {
        return this.header(Header.CONTENT_ENCODING);
    }

    public boolean isGzip() {
        String contentEncoding = this.contentEncoding();
        return contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip");
    }

    public String getCookieStr() {
        return this.header(Header.SET_COOKIE);
    }

    public List<HttpCookie> getCookie() {
        String cookieStr = this.getCookieStr();
        if (StrUtil.isNotBlank(cookieStr)) {
            return HttpCookie.parse(cookieStr);
        }
        return null;
    }

    public InputStream bodyStream() {
        if (this.isAsync) {
            return this.in;
        }
        return new ByteArrayInputStream(this.out.toByteArray());
    }

    public byte[] bodyBytes() {
        this.sync();
        return null == this.out ? null : this.out.toByteArray();
    }

    public String body() throws HttpException {
        try {
            return HttpUtil.getString(this.bodyBytes(), this.charset, null == this.charset);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = StrUtil.builder();
        sb.append("Response Headers: ").append("\r\n");
        for (Map.Entry entry : this.headers.entrySet()) {
            sb.append("    ").append(entry).append("\r\n");
        }
        sb.append("Response Body: ").append("\r\n");
        sb.append("    ").append(this.body()).append("\r\n");
        return sb.toString();
    }

    private HttpResponse init() throws HttpException {
        block4: {
            try {
                this.status = this.httpConnection.responseCode();
                this.headers = this.httpConnection.headers();
                Charset charset = this.httpConnection.getCharset();
                if (null != charset) {
                    this.charset = charset;
                }
                this.in = this.status < 400 ? this.httpConnection.getInputStream() : this.httpConnection.getErrorStream();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block4;
                throw new HttpException(e);
            }
        }
        if (null == this.in) {
            this.in = new ByteArrayInputStream(StrUtil.format((CharSequence)"Error request, response status: {}", this.status).getBytes());
        }
        return this.isAsync ? this : this.forceSync();
    }

    private void readBody(InputStream in) throws IORuntimeException {
        block6: {
            int contentLength;
            if (this.ignoreBody) {
                return;
            }
            if (this.isGzip() && !(in instanceof GZIPInputStream)) {
                try {
                    in = new GZIPInputStream(in);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.out = (contentLength = Convert.toInt(this.header(Header.CONTENT_LENGTH), 0).intValue()) > 0 ? new FastByteArrayOutputStream(contentLength) : new FastByteArrayOutputStream();
            try {
                IoUtil.copy(in, this.out);
            }
            catch (IORuntimeException e) {
                if (e.getCause() instanceof EOFException) break block6;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse forceSync() {
        block7: {
            try {
                this.readBody(this.in);
            }
            catch (IORuntimeException e) {
                if (e.getCause() instanceof FileNotFoundException) {
                    break block7;
                }
                throw new HttpException(e);
            }
            finally {
                if (this.isAsync) {
                    this.isAsync = false;
                }
                IoUtil.close(this.in);
                this.httpConnection.disconnect();
            }
        }
        return this;
    }
}

