/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.script;

import com.xiaoleilu.hutool.script.JavaScriptEngine;
import com.xiaoleilu.hutool.script.ScriptRuntimeException;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptUtil {
    public static ScriptEngine getScript(String name) {
        return new ScriptEngineManager().getEngineByName(name);
    }

    public static JavaScriptEngine getJavaScriptEngine() {
        return new JavaScriptEngine();
    }

    public static Object eval(String script) throws ScriptRuntimeException {
        try {
            return ScriptUtil.compile(script).eval();
        }
        catch (ScriptException e) {
            throw new ScriptRuntimeException(e);
        }
    }

    public static Object eval(String script, ScriptContext context) throws ScriptRuntimeException {
        try {
            return ScriptUtil.compile(script).eval(context);
        }
        catch (ScriptException e) {
            throw new ScriptRuntimeException(e);
        }
    }

    public static Object eval(String script, Bindings bindings) throws ScriptRuntimeException {
        try {
            return ScriptUtil.compile(script).eval(bindings);
        }
        catch (ScriptException e) {
            throw new ScriptRuntimeException(e);
        }
    }

    public static CompiledScript compile(String script) throws ScriptRuntimeException {
        try {
            return ScriptUtil.compile(ScriptUtil.getJavaScriptEngine(), script);
        }
        catch (ScriptException e) {
            throw new ScriptRuntimeException(e);
        }
    }

    public static CompiledScript compile(ScriptEngine engine, String script) throws ScriptException {
        if (engine instanceof Compilable) {
            Compilable compEngine = (Compilable)((Object)engine);
            return compEngine.compile(script);
        }
        return null;
    }
}

