/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.openapi.security.signature;

public class RC4Util {
    public static String decryRC4(byte[] data, String key) {
        if (data == null || key == null) {
            return null;
        }
        return RC4Util.asString(RC4Util.RC4Base(data, key));
    }

    public static String decryRC4(String data, String key) {
        if (data == null || key == null) {
            return null;
        }
        return new String(RC4Util.RC4Base(RC4Util.HexString2Bytes(data), key));
    }

    public static byte[] encryRC4Byte(String data, String key) {
        if (data == null || key == null) {
            return null;
        }
        byte[] bData = data.getBytes();
        return RC4Util.RC4Base(bData, key);
    }

    public static String encryRC4String(String data, String key) {
        if (data == null || key == null) {
            return null;
        }
        return RC4Util.toHexString(RC4Util.asString(RC4Util.encryRC4Byte(data, key)));
    }

    private static String asString(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length);
        int i = 0;
        while (i < buf.length) {
            strbuf.append((char)buf[i]);
            ++i;
        }
        return strbuf.toString();
    }

    private static byte[] initKey(String aKey) {
        byte[] bkey = aKey.getBytes();
        byte[] state = new byte[256];
        int i = 0;
        while (i < 256) {
            state[i] = (byte)i;
            ++i;
        }
        int index1 = 0;
        int index2 = 0;
        if (bkey == null || bkey.length == 0) {
            return null;
        }
        int i2 = 0;
        while (i2 < 256) {
            index2 = (bkey[index1] & 0xFF) + (state[i2] & 0xFF) + index2 & 0xFF;
            byte tmp = state[i2];
            state[i2] = state[index2];
            state[index2] = tmp;
            index1 = (index1 + 1) % bkey.length;
            ++i2;
        }
        return state;
    }

    private static String toHexString(String s) {
        String str = "";
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            String s4 = Integer.toHexString(ch & 0xFF);
            if (s4.length() == 1) {
                s4 = String.valueOf('0') + s4;
            }
            str = String.valueOf(str) + s4;
            ++i;
        }
        return str;
    }

    private static byte[] HexString2Bytes(String src) {
        int size = src.length();
        byte[] ret = new byte[size / 2];
        byte[] tmp = src.getBytes();
        int i = 0;
        while (i < size / 2) {
            ret[i] = RC4Util.uniteBytes(tmp[i * 2], tmp[i * 2 + 1]);
            ++i;
        }
        return ret;
    }

    private static byte uniteBytes(byte src0, byte src1) {
        char _b0 = (char)Byte.decode("0x" + new String(new byte[]{src0})).byteValue();
        _b0 = (char)(_b0 << 4);
        char _b1 = (char)Byte.decode("0x" + new String(new byte[]{src1})).byteValue();
        byte ret = (byte)(_b0 ^ _b1);
        return ret;
    }

    private static byte[] RC4Base(byte[] input, String mKkey) {
        int x = 0;
        int y = 0;
        byte[] key = RC4Util.initKey(mKkey);
        byte[] result = new byte[input.length];
        int i = 0;
        while (i < input.length) {
            x = x + 1 & 0xFF;
            y = (key[x] & 0xFF) + y & 0xFF;
            byte tmp = key[x];
            key[x] = key[y];
            key[y] = tmp;
            int xorIndex = (key[x] & 0xFF) + (key[y] & 0xFF) & 0xFF;
            result[i] = (byte)(input[i] ^ key[xorIndex]);
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

