/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.scorpoin.common;

import com.alibaba.fastjson.JSONObject;
import com.zhongan.scorpoin.biz.common.CommonResponse;
import com.zhongan.scorpoin.common.DefaultRequest;
import com.zhongan.scorpoin.common.DefaultResponse;
import com.zhongan.scorpoin.common.ProtocolParameterEnum;
import com.zhongan.scorpoin.common.ZhongAnEnvEnum;
import com.zhongan.scorpoin.common.ZhongAnOpenErrorEnum;
import com.zhongan.scorpoin.common.ZhongAnOpenException;
import com.zhongan.scorpoin.signature.SignatureUtils;
import com.zhongan.scorpoin.util.StringUtils;
import com.zhongan.scorpoin.util.ZhongAnOpenHttpUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZhongAnApiClient {
    private int connectTimeout = 3000;
    private int readTimeout = 80000;
    private String env;
    private String appKey;
    private String privateKey;
    private String url;
    private String zaPublicKey;
    private String charset = "UTF-8";
    private String signType = "RSA";
    private String version = "1.0.0";
    private String format = "json";
    private String timestamp;

    public ZhongAnApiClient(String env, String appKey, String privateKey) {
        this.env = env;
        this.appKey = appKey;
        this.privateKey = privateKey;
    }

    public ZhongAnApiClient(String env, String appKey, String privateKey, String version) {
        this.env = env;
        this.appKey = appKey;
        this.privateKey = privateKey;
        this.version = version;
    }

    public ZhongAnApiClient(String env, String url, String appKey, String privateKey, String version) {
        this.url = url;
        this.env = env;
        this.appKey = appKey;
        this.privateKey = privateKey;
        this.version = version;
    }

    public ZhongAnApiClient(String env, String appKey, String privateKey, String charset, String signType, String version, String format, int connectTimeout, int readTimeout) {
        this.env = env;
        this.appKey = appKey;
        this.privateKey = privateKey;
        this.charset = charset;
        this.signType = signType;
        this.version = version;
        this.format = format;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    private void _init() throws ZhongAnOpenException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        this.timestamp = sdf.format(new Date());
        sdf = null;
        ZhongAnEnvEnum envEnum = ZhongAnEnvEnum.get(this.env);
        if (envEnum == null) {
            if (this.env.startsWith("uat")) {
                envEnum = ZhongAnEnvEnum.get("uat");
            } else {
                throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ARGUMENTS_ILLEGAL.getCode(), "env\u5fc5\u987b\u662fdev,iTest,uat,prd\u4e2d\u7684\u4e00\u4e2a");
            }
        }
        if (StringUtils.isEmpty(this.url) || "prd".equals(this.env)) {
            this.url = envEnum.getUrl();
        }
        this.zaPublicKey = envEnum.getPublicKey();
    }

    public DefaultResponse call(DefaultRequest req) throws ZhongAnOpenException {
        this._init();
        req.init();
        req.checkSysParams();
        req.checkBizParams();
        JSONObject encryptSignJSON = req.buildEncryptSignParamMap();
        encryptSignJSON.put(ProtocolParameterEnum.APP_KEY.getCode(), (Object)this.appKey);
        encryptSignJSON.put(ProtocolParameterEnum.TIME_STAMP.getCode(), (Object)this.timestamp);
        encryptSignJSON.put(ProtocolParameterEnum.FORMAT.getCode(), (Object)this.format);
        encryptSignJSON.put(ProtocolParameterEnum.SIGN_TYPE.getCode(), (Object)this.signType);
        encryptSignJSON.put(ProtocolParameterEnum.CHARSET.getCode(), (Object)this.charset);
        encryptSignJSON.put(ProtocolParameterEnum.VERSION.getCode(), (Object)this.version);
        Map<String, Object> rt = this.doPost(encryptSignJSON);
        if (rt == null) {
            return null;
        }
        DefaultResponse response = null;
        if (rt.get("bizContent") != null) {
            if (CommonResponse.class.getName().equals(req.getResponse().getClass().getName())) {
                response = new CommonResponse();
                response.setBizContent((String)rt.get("bizContent"));
            } else {
                response = (DefaultResponse)JSONObject.parseObject((String)((String)rt.get("bizContent")), req.getResponse().getClass());
            }
        } else {
            response = req.getResponse();
        }
        if (rt.get("errorCode") != null) {
            response.setErrorCode((String)rt.get("errorCode"));
        }
        if (rt.get("errorMsg") != null) {
            response.setErrorMsg((String)rt.get("errorMsg"));
        }
        response.setCharset((String)rt.get("charset"));
        response.setFormat((String)rt.get("format"));
        response.setSignType((String)rt.get("signType"));
        response.setTimestamp((String)rt.get("timestamp"));
        return response;
    }

    protected Map<String, Object> doPost(JSONObject paramJSON) throws ZhongAnOpenException {
        Map<Object, Object> encryptMap = new HashMap();
        try {
            encryptMap = SignatureUtils.encryptAndSign((Map<String, Object>)paramJSON, this.zaPublicKey, this.privateKey, "utf-8", true, true);
        }
        catch (Exception e) {
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ENCRYPT_SIGN_FAILED.getCode(), e.getMessage(), e);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<Object, Object> en : encryptMap.entrySet()) {
            params.put((String)en.getKey(), (String)en.getValue());
        }
        String gatewayResponse = null;
        try {
            gatewayResponse = ZhongAnOpenHttpUtils.doPost(this.url, params, this.connectTimeout, this.readTimeout);
        }
        catch (IOException e) {
            throw new ZhongAnOpenException(e);
        }
        JSONObject responseJson = null;
        try {
            responseJson = JSONObject.parseObject((String)gatewayResponse);
        }
        catch (Exception e) {
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ERROR_RESPONSE.getCode(), ZhongAnOpenErrorEnum.ERROR_RESPONSE.getDescription());
        }
        boolean isDecrypt = !StringUtils.isEmpty(responseJson.getString("bizContent"));
        try {
            String responseBizContent = SignatureUtils.checkSignAndDecrypt((Map<String, Object>)responseJson, this.zaPublicKey, this.privateKey, true, isDecrypt);
            responseJson.put("bizContent", (Object)responseBizContent);
        }
        catch (Exception e) {
            throw new ZhongAnOpenException(e);
        }
        return responseJson;
    }
}

