/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.scorpoin.util;

import com.zhongan.scorpoin.common.ZhongAnOpenErrorEnum;
import com.zhongan.scorpoin.common.ZhongAnOpenException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class CheckArgUtil {
    public static final String REGEX_MOBILE = "^((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$";
    public static final String REGEX_EMAIL = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    public static final String REGEX_CHINESE_NAME = "^[\u4e00-\u9fa5]{2,5}$";
    public static final String REGEX_ID_CARD = "(^\\d{18}$)|(^\\d{15}$)";
    public static final String REGEX_CAR_NO = "^[\u4e00-\u9fa5]{1}[A-Z]{1}[A-Z_0-9]{5}$";
    public static final String REGEX_DATEFORMAT = "yyyy-MM-dd";

    public static void main(String[] args) throws Exception {
    }

    public static void checkArg(String type, String arg) throws ZhongAnOpenException {
        Method[] methods;
        Method[] methodArray = methods = CheckArgUtil.class.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equalsIgnoreCase(type)) {
                try {
                    m.invoke(null, arg);
                }
                catch (Exception e) {
                    throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ARGUMENTS_ILLEGAL.getCode(), e);
                }
                return;
            }
            ++n2;
        }
    }

    public static void checkCarNo(String carNo) throws ZhongAnOpenException {
        if (!Pattern.matches(REGEX_CAR_NO, carNo)) {
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ARGUMENTS_ILLEGAL.getCode(), "\u8f66\u724c\u53f7:" + carNo + " \u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }

    public static void checkDateByFormat(String dateStr, String dateFormat) throws ZhongAnOpenException {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        try {
            Date date = formatter.parse(dateStr);
            if (!dateStr.equals(formatter.format(date))) {
                throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ARGUMENTS_ILLEGAL.getCode(), "\u65e5\u671f:" + dateStr + " \u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
        catch (Exception e) {
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ARGUMENTS_ILLEGAL.getCode(), e);
        }
    }

    public static void checkDate(String dateStr) throws ZhongAnOpenException {
        CheckArgUtil.checkDateByFormat(dateStr, REGEX_DATEFORMAT);
    }

    public static void checkMobile(String mobile) throws ZhongAnOpenException {
        if (!Pattern.matches(REGEX_MOBILE, mobile)) {
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ARGUMENTS_ILLEGAL.getCode(), "\u624b\u673a\u53f7:" + mobile + " \u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }

    public static void checkEmail(String email) throws ZhongAnOpenException {
        if (!Pattern.matches(REGEX_EMAIL, email)) {
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ARGUMENTS_ILLEGAL.getCode(), "\u90ae\u7bb1:" + email + " \u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }

    public static void checkChineseName(String name) throws ZhongAnOpenException {
        if (!Pattern.matches(REGEX_CHINESE_NAME, name)) {
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ARGUMENTS_ILLEGAL.getCode(), "\u4e2d\u6587\u540d:" + name + " \u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }

    public static void checkIDCard(String idCard) throws ZhongAnOpenException {
        if (!Pattern.matches(REGEX_ID_CARD, idCard)) {
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ARGUMENTS_ILLEGAL.getCode(), "\u8eab\u4efd\u8bc1:" + idCard + " \u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }
}

