/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.commons.encodedtoken;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.oltu.commons.encodedtoken.TokenDecoder;

public abstract class TokenReader<T>
extends TokenDecoder {
    private final Pattern base64urlTokenPattern = Pattern.compile("([a-zA-Z0-9/+=]+)\\.([a-zA-Z0-9/+=]+)\\.(.+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read(String base64String) {
        Matcher matcher;
        if (base64String == null || base64String.isEmpty()) {
            throw new IllegalArgumentException("Impossible to obtain a Token from a null or empty string");
        }
        StringBuilder buffer = new StringBuilder();
        BufferedReader reader = new BufferedReader(new StringReader(base64String));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                buffer.append(line.trim());
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        if (!(matcher = this.base64urlTokenPattern.matcher(buffer.toString())).matches()) {
            throw new IllegalArgumentException(base64String + "is not a valid Token, it does not match with the pattern: " + this.base64urlTokenPattern.pattern());
        }
        String header = matcher.group(1);
        String decodedHeader = TokenReader.base64Decode(header);
        String body = matcher.group(2);
        String decodedBody = TokenReader.base64Decode(body);
        String signature = matcher.group(3);
        return this.build(base64String, decodedHeader, decodedBody, signature);
    }

    protected abstract T build(String var1, String var2, String var3, String var4);
}

