/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.commons.json;

import org.apache.oltu.commons.json.CustomizableBuilder;
import org.json.JSONArray;
import org.json.JSONTokener;

public abstract class CustomizableEntityReader<E, B extends CustomizableBuilder<E>> {
    private final B builder;

    public CustomizableEntityReader(B builder) {
        this.builder = builder;
    }

    protected final B getBuilder() {
        return this.builder;
    }

    public void read(String jsonString) {
        JSONTokener x = new JSONTokener(jsonString);
        if (x.nextClean() != '{') {
            throw new IllegalArgumentException(String.format("String '%s' is not a valid JSON object representation, a JSON object text must begin with '{'", jsonString));
        }
        block8: while (true) {
            Object[] value;
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw new IllegalArgumentException(String.format("String '%s' is not a valid JSON object representation, a JSON object text must end with '}'", jsonString));
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw new IllegalArgumentException(String.format("String '%s' is not a valid JSON object representation, expected a ':' after the key '%s'", jsonString, key));
            }
            if ((value = x.nextValue()) != null) {
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    Object[] values = new Object[array.length()];
                    for (int i = 0; i < array.length(); ++i) {
                        values[i] = array.get(i);
                    }
                    value = values;
                }
                if (!this.handleProperty(key, value)) {
                    ((CustomizableBuilder)this.builder).setCustomField(key, value);
                }
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw new IllegalArgumentException("Expected a ',' or '}'");
    }

    protected abstract <T> boolean handleProperty(String var1, T var2);
}

