/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.config.BaseCacheConfiguration;
import org.ehcache.expiry.Expiry;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.config.event.DefaultCacheEventDispatcherConfiguration;
import org.ehcache.impl.config.event.DefaultCacheEventListenerConfiguration;
import org.ehcache.impl.config.event.DefaultEventSourceConfiguration;
import org.ehcache.impl.config.loaderwriter.DefaultCacheLoaderWriterConfiguration;
import org.ehcache.impl.config.serializer.DefaultSerializerConfiguration;
import org.ehcache.impl.config.store.disk.OffHeapDiskStoreConfiguration;
import org.ehcache.impl.config.store.heap.DefaultSizeOfEngineConfiguration;
import org.ehcache.impl.copy.SerializingCopier;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceConfiguration;

public class CacheConfigurationBuilder<K, V>
implements Builder<CacheConfiguration<K, V>> {
    private final Collection<ServiceConfiguration<?>> serviceConfigurations = new HashSet();
    private Expiry<? super K, ? super V> expiry;
    private ClassLoader classLoader = null;
    private EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private ResourcePools resourcePools;
    private Class<? super K> keyType;
    private Class<? super V> valueType;

    public static <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilder(Class<K> keyType, Class<V> valueType, ResourcePools resourcePools) {
        return new CacheConfigurationBuilder<K, V>(keyType, valueType, resourcePools);
    }

    public static <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilder(Class<K> keyType, Class<V> valueType, Builder<? extends ResourcePools> resourcePoolsBuilder) {
        return new CacheConfigurationBuilder<K, V>(keyType, valueType, resourcePoolsBuilder.build());
    }

    public static <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilder(CacheConfiguration<K, V> configuration) {
        CacheConfigurationBuilder<K, V> builder = CacheConfigurationBuilder.newCacheConfigurationBuilder(configuration.getKeyType(), configuration.getValueType(), configuration.getResourcePools()).withClassLoader(configuration.getClassLoader()).withEvictionAdvisor(configuration.getEvictionAdvisor()).withExpiry(configuration.getExpiry());
        for (ServiceConfiguration<?> serviceConfig : configuration.getServiceConfigurations()) {
            builder = builder.add(serviceConfig);
        }
        return builder;
    }

    private CacheConfigurationBuilder(Class<K> keyType, Class<V> valueType, ResourcePools resourcePools) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.resourcePools = resourcePools;
    }

    private CacheConfigurationBuilder(CacheConfigurationBuilder<? super K, ? super V> other) {
        this.keyType = other.keyType;
        this.valueType = other.valueType;
        this.expiry = other.expiry;
        this.classLoader = other.classLoader;
        this.evictionAdvisor = other.evictionAdvisor;
        this.resourcePools = other.resourcePools;
        this.serviceConfigurations.addAll(other.serviceConfigurations);
    }

    public CacheConfigurationBuilder<K, V> add(ServiceConfiguration<?> configuration) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        if (this.getExistingServiceConfiguration(configuration.getClass()) != null) {
            if (configuration instanceof DefaultCopierConfiguration) {
                DefaultCopierConfiguration copierConfiguration = (DefaultCopierConfiguration)configuration;
                this.removeExistingCopierConfigFor(copierConfiguration.getType(), otherBuilder);
            } else if (configuration instanceof DefaultSerializerConfiguration) {
                DefaultSerializerConfiguration serializerConfiguration = (DefaultSerializerConfiguration)configuration;
                this.removeExistingSerializerConfigFor(serializerConfiguration.getType(), otherBuilder);
            } else if (!(configuration instanceof DefaultCacheEventListenerConfiguration)) {
                throw new IllegalStateException("Cannot add a generic service configuration when another one already exists. Rely on specific with* methods or make sure your remove other configuration first.");
            }
        }
        otherBuilder.serviceConfigurations.add(configuration);
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> add(Builder<? extends ServiceConfiguration<?>> configurationBuilder) {
        return this.add(configurationBuilder.build());
    }

    public CacheConfigurationBuilder<K, V> withEvictionAdvisor(EvictionAdvisor<? super K, ? super V> evictionAdvisor) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.evictionAdvisor = evictionAdvisor;
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> remove(ServiceConfiguration<?> configuration) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.serviceConfigurations.remove(configuration);
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> clearAllServiceConfig() {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.serviceConfigurations.clear();
        return otherBuilder;
    }

    public <T extends ServiceConfiguration<?>> T getExistingServiceConfiguration(Class<T> clazz) {
        for (ServiceConfiguration<?> serviceConfiguration : this.serviceConfigurations) {
            if (!clazz.equals(serviceConfiguration.getClass())) continue;
            return (T)((ServiceConfiguration)clazz.cast(serviceConfiguration));
        }
        return null;
    }

    public <T extends ServiceConfiguration<?>> List<T> getExistingServiceConfigurations(Class<T> clazz) {
        ArrayList<T> results = new ArrayList<T>();
        for (ServiceConfiguration<?> serviceConfiguration : this.serviceConfigurations) {
            if (!clazz.equals(serviceConfiguration.getClass())) continue;
            results.add(clazz.cast(serviceConfiguration));
        }
        return results;
    }

    public CacheConfigurationBuilder<K, V> withClassLoader(ClassLoader classLoader) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.classLoader = classLoader;
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withResourcePools(ResourcePools resourcePools) {
        if (resourcePools == null) {
            throw new NullPointerException("Null resource pools");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.resourcePools = resourcePools;
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withResourcePools(ResourcePoolsBuilder resourcePoolsBuilder) {
        if (resourcePoolsBuilder == null) {
            throw new NullPointerException("Null resource pools builder");
        }
        return this.withResourcePools(resourcePoolsBuilder.build());
    }

    public CacheConfigurationBuilder<K, V> withExpiry(Expiry<? super K, ? super V> expiry) {
        if (expiry == null) {
            throw new NullPointerException("Null expiry");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.expiry = expiry;
        return otherBuilder;
    }

    public boolean hasConfiguredExpiry() {
        return this.expiry != null;
    }

    public CacheConfigurationBuilder<K, V> withLoaderWriter(CacheLoaderWriter<K, V> loaderWriter) {
        if (loaderWriter == null) {
            throw new NullPointerException("Null loaderWriter");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        DefaultCacheLoaderWriterConfiguration existingServiceConfiguration = otherBuilder.getExistingServiceConfiguration(DefaultCacheLoaderWriterConfiguration.class);
        if (existingServiceConfiguration != null) {
            otherBuilder.serviceConfigurations.remove(existingServiceConfiguration);
        }
        otherBuilder.serviceConfigurations.add(new DefaultCacheLoaderWriterConfiguration(loaderWriter));
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withLoaderWriter(Class<CacheLoaderWriter<K, V>> loaderWriterClass, Object ... arguments) {
        if (loaderWriterClass == null) {
            throw new NullPointerException("Null loaderWriterClass");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        DefaultCacheLoaderWriterConfiguration existingServiceConfiguration = otherBuilder.getExistingServiceConfiguration(DefaultCacheLoaderWriterConfiguration.class);
        if (existingServiceConfiguration != null) {
            otherBuilder.serviceConfigurations.remove(existingServiceConfiguration);
        }
        otherBuilder.serviceConfigurations.add(new DefaultCacheLoaderWriterConfiguration((Class<? extends CacheLoaderWriter<?, ?>>)loaderWriterClass, arguments));
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withKeySerializingCopier() {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        this.removeExistingCopierConfigFor(DefaultCopierConfiguration.Type.KEY, otherBuilder);
        otherBuilder.serviceConfigurations.add(new DefaultCopierConfiguration(SerializingCopier.class, DefaultCopierConfiguration.Type.KEY));
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withValueSerializingCopier() {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        this.removeExistingCopierConfigFor(DefaultCopierConfiguration.Type.VALUE, otherBuilder);
        otherBuilder.serviceConfigurations.add(new DefaultCopierConfiguration(SerializingCopier.class, DefaultCopierConfiguration.Type.VALUE));
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withKeyCopier(Copier<K> keyCopier) {
        if (keyCopier == null) {
            throw new NullPointerException("Null key copier");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        this.removeExistingCopierConfigFor(DefaultCopierConfiguration.Type.KEY, otherBuilder);
        otherBuilder.serviceConfigurations.add(new DefaultCopierConfiguration<K>(keyCopier, DefaultCopierConfiguration.Type.KEY));
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withKeyCopier(Class<? extends Copier<K>> keyCopierClass) {
        if (keyCopierClass == null) {
            throw new NullPointerException("Null key copier class");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        this.removeExistingCopierConfigFor(DefaultCopierConfiguration.Type.KEY, otherBuilder);
        otherBuilder.serviceConfigurations.add(new DefaultCopierConfiguration(keyCopierClass, DefaultCopierConfiguration.Type.KEY));
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withValueCopier(Copier<V> valueCopier) {
        if (valueCopier == null) {
            throw new NullPointerException("Null value copier");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        this.removeExistingCopierConfigFor(DefaultCopierConfiguration.Type.VALUE, otherBuilder);
        otherBuilder.serviceConfigurations.add(new DefaultCopierConfiguration<V>(valueCopier, DefaultCopierConfiguration.Type.VALUE));
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withValueCopier(Class<? extends Copier<V>> valueCopierClass) {
        if (valueCopierClass == null) {
            throw new NullPointerException("Null value copier");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        this.removeExistingCopierConfigFor(DefaultCopierConfiguration.Type.VALUE, otherBuilder);
        otherBuilder.serviceConfigurations.add(new DefaultCopierConfiguration(valueCopierClass, DefaultCopierConfiguration.Type.VALUE));
        return otherBuilder;
    }

    private void removeExistingCopierConfigFor(DefaultCopierConfiguration.Type type, CacheConfigurationBuilder<K, V> otherBuilder) {
        List<DefaultCopierConfiguration> existingServiceConfigurations = otherBuilder.getExistingServiceConfigurations(DefaultCopierConfiguration.class);
        for (DefaultCopierConfiguration configuration : existingServiceConfigurations) {
            if (!configuration.getType().equals((Object)type)) continue;
            otherBuilder.serviceConfigurations.remove(configuration);
        }
    }

    private void removeExistingSerializerConfigFor(DefaultSerializerConfiguration.Type type, CacheConfigurationBuilder<K, V> otherBuilder) {
        List<DefaultSerializerConfiguration> existingServiceConfigurations = otherBuilder.getExistingServiceConfigurations(DefaultSerializerConfiguration.class);
        for (DefaultSerializerConfiguration configuration : existingServiceConfigurations) {
            if (!configuration.getType().equals((Object)type)) continue;
            otherBuilder.serviceConfigurations.remove(configuration);
        }
    }

    public CacheConfigurationBuilder<K, V> withKeySerializer(Serializer<K> keySerializer) {
        if (keySerializer == null) {
            throw new NullPointerException("Null key serializer");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        this.removeExistingSerializerConfigFor(DefaultSerializerConfiguration.Type.KEY, otherBuilder);
        otherBuilder.serviceConfigurations.add(new DefaultSerializerConfiguration<K>(keySerializer, DefaultSerializerConfiguration.Type.KEY));
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withKeySerializer(Class<? extends Serializer<K>> keySerializerClass) {
        if (keySerializerClass == null) {
            throw new NullPointerException("Null key serializer class");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        this.removeExistingSerializerConfigFor(DefaultSerializerConfiguration.Type.KEY, otherBuilder);
        otherBuilder.serviceConfigurations.add(new DefaultSerializerConfiguration(keySerializerClass, DefaultSerializerConfiguration.Type.KEY));
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withValueSerializer(Serializer<V> valueSerializer) {
        if (valueSerializer == null) {
            throw new NullPointerException("Null value serializer");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        this.removeExistingSerializerConfigFor(DefaultSerializerConfiguration.Type.VALUE, otherBuilder);
        otherBuilder.serviceConfigurations.add(new DefaultSerializerConfiguration<V>(valueSerializer, DefaultSerializerConfiguration.Type.VALUE));
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withValueSerializer(Class<? extends Serializer<V>> valueSerializerClass) {
        if (valueSerializerClass == null) {
            throw new NullPointerException("Null value serializer class");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        this.removeExistingSerializerConfigFor(DefaultSerializerConfiguration.Type.VALUE, otherBuilder);
        otherBuilder.serviceConfigurations.add(new DefaultSerializerConfiguration(valueSerializerClass, DefaultSerializerConfiguration.Type.VALUE));
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withDispatcherConcurrency(int dispatcherConcurrency) {
        DefaultEventSourceConfiguration configuration = new DefaultEventSourceConfiguration(dispatcherConcurrency);
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        DefaultEventSourceConfiguration existingServiceConfiguration = otherBuilder.getExistingServiceConfiguration(DefaultEventSourceConfiguration.class);
        if (existingServiceConfiguration != null) {
            otherBuilder.serviceConfigurations.remove(existingServiceConfiguration);
        }
        otherBuilder.serviceConfigurations.add(configuration);
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withEventListenersThreadPool(String threadPoolAlias) {
        DefaultCacheEventDispatcherConfiguration configuration = new DefaultCacheEventDispatcherConfiguration(threadPoolAlias);
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        DefaultCacheEventDispatcherConfiguration existingServiceConfiguration = otherBuilder.getExistingServiceConfiguration(DefaultCacheEventDispatcherConfiguration.class);
        if (existingServiceConfiguration != null) {
            otherBuilder.serviceConfigurations.remove(existingServiceConfiguration);
        }
        otherBuilder.serviceConfigurations.add(configuration);
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withDiskStoreThreadPool(String threadPoolAlias, int concurrency) {
        OffHeapDiskStoreConfiguration configuration = new OffHeapDiskStoreConfiguration(threadPoolAlias, concurrency);
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        OffHeapDiskStoreConfiguration existingServiceConfiguration = this.getExistingServiceConfiguration(OffHeapDiskStoreConfiguration.class);
        if (existingServiceConfiguration != null) {
            otherBuilder.serviceConfigurations.remove(existingServiceConfiguration);
        }
        otherBuilder.serviceConfigurations.add(configuration);
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withSizeOfMaxObjectGraph(long size) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        DefaultSizeOfEngineConfiguration configuration = otherBuilder.getExistingServiceConfiguration(DefaultSizeOfEngineConfiguration.class);
        if (configuration == null) {
            otherBuilder.serviceConfigurations.add(new DefaultSizeOfEngineConfiguration(Long.MAX_VALUE, DefaultSizeOfEngineConfiguration.DEFAULT_UNIT, size));
        } else {
            otherBuilder.serviceConfigurations.remove(configuration);
            otherBuilder.serviceConfigurations.add(new DefaultSizeOfEngineConfiguration(configuration.getMaxObjectSize(), configuration.getUnit(), size));
        }
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withSizeOfMaxObjectSize(long size, MemoryUnit unit) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        DefaultSizeOfEngineConfiguration configuration = this.getExistingServiceConfiguration(DefaultSizeOfEngineConfiguration.class);
        if (configuration == null) {
            otherBuilder.serviceConfigurations.add(new DefaultSizeOfEngineConfiguration(size, unit, 1000L));
        } else {
            otherBuilder.serviceConfigurations.remove(configuration);
            otherBuilder.serviceConfigurations.add(new DefaultSizeOfEngineConfiguration(size, unit, configuration.getMaxObjectGraphSize()));
        }
        return otherBuilder;
    }

    @Override
    public CacheConfiguration<K, V> build() {
        return new BaseCacheConfiguration<K, V>(this.keyType, this.valueType, this.evictionAdvisor, this.classLoader, this.expiry, this.resourcePools, this.serviceConfigurations.toArray(new ServiceConfiguration[this.serviceConfigurations.size()]));
    }
}

