/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.internal.service;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ehcache.core.internal.util.ClassLoading;
import org.ehcache.core.spi.service.ServiceFactory;
import org.ehcache.spi.service.PluralService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLocator
implements ServiceProvider<Service> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLocator.class);
    private final ConcurrentMap<Class<? extends Service>, Set<Service>> services = new ConcurrentHashMap<Class<? extends Service>, Set<Service>>();
    private final ServiceLoader<ServiceFactory> serviceFactory = ClassLoading.libraryServiceLoaderFor(ServiceFactory.class);
    private final ReadWriteLock runningLock = new ReentrantReadWriteLock();
    private final AtomicBoolean running = new AtomicBoolean(false);

    public ServiceLocator(Service ... services) {
        for (Service service : services) {
            this.addService(service);
        }
    }

    private <T extends Service> Collection<T> discoverServices(Class<T> serviceClass, ServiceCreationConfiguration<T> config) {
        ArrayList<T> addedServices = new ArrayList<T>();
        for (ServiceFactory<T> factory : ServiceLocator.getServiceFactories(this.serviceFactory)) {
            Class<T> factoryServiceType = factory.getServiceType();
            if (!serviceClass.isAssignableFrom(factoryServiceType) || this.services.containsKey(factoryServiceType)) continue;
            T service = factory.create(config);
            this.addService((Service)service);
            addedServices.add(service);
            if (config == null) continue;
            return addedServices;
        }
        return addedServices;
    }

    private static <T extends Service> Iterable<ServiceFactory<T>> getServiceFactories(ServiceLoader<ServiceFactory> serviceFactory) {
        ArrayList<ServiceFactory<T>> list = new ArrayList<ServiceFactory<T>>();
        for (ServiceFactory factory : serviceFactory) {
            list.add(factory);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(Service service) {
        Lock lock = this.runningLock.readLock();
        lock.lock();
        try {
            HashSet serviceClazzes = new HashSet();
            for (Class<?> clazz : this.getAllInterfaces(service.getClass())) {
                if (Service.class == clazz || !Service.class.isAssignableFrom(clazz)) continue;
                Class<?> serviceClass = clazz;
                serviceClazzes.add(serviceClass);
            }
            if (this.services.putIfAbsent(service.getClass(), Collections.singleton(service)) != null) {
                throw new IllegalStateException("Registration of duplicate service " + service.getClass());
            }
            for (Class<Object> clazz : serviceClazzes) {
                if (clazz.isAnnotationPresent(PluralService.class)) {
                    LinkedHashSet<Service> registeredServices = (LinkedHashSet<Service>)this.services.get(clazz);
                    if (registeredServices == null) {
                        registeredServices = new LinkedHashSet<Service>();
                        this.services.put(clazz, registeredServices);
                    }
                    registeredServices.add(service);
                    continue;
                }
                if (this.services.putIfAbsent(clazz, Collections.singleton(service)) == null) continue;
                StringBuilder message = new StringBuilder("Duplicate service implementation(s) found for ").append(service.getClass());
                for (Class clazz2 : serviceClazzes) {
                    Service declaredService;
                    if (clazz2.isAnnotationPresent(PluralService.class) || (declaredService = (Service)((Set)this.services.get(clazz2)).iterator().next()) == null) continue;
                    message.append("\n\t\t- ").append(clazz2).append(" already has ").append(declaredService.getClass());
                }
                throw new IllegalStateException(message.toString());
            }
            if (this.running.get()) {
                this.loadDependenciesOf(service.getClass());
                service.start(this);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private Collection<Class<?>> getAllInterfaces(Class<?> clazz) {
        ArrayList interfaces = new ArrayList();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Class<?> i : c.getInterfaces()) {
                interfaces.add(i);
                interfaces.addAll(this.getAllInterfaces(i));
            }
        }
        return interfaces;
    }

    public <T extends Service> T getOrCreateServiceFor(ServiceCreationConfiguration<T> config) {
        return this.getServiceInternal(config.getServiceType(), config, true);
    }

    @Override
    public <T extends Service> T getService(Class<T> serviceType) {
        return this.getServiceInternal(serviceType, null, false);
    }

    private <T extends Service> T getServiceInternal(Class<T> serviceType, ServiceCreationConfiguration<T> config, boolean shouldCreate) {
        if (serviceType.isAnnotationPresent(PluralService.class)) {
            throw new IllegalArgumentException(serviceType.getName() + " is marked as a PluralService");
        }
        Collection<T> registeredServices = this.findServices(serviceType, config, shouldCreate);
        if (registeredServices.size() > 1) {
            throw new AssertionError((Object)("The non-PluralService type" + serviceType.getName() + " has more than one service registered"));
        }
        return (T)(registeredServices.isEmpty() ? null : (Service)registeredServices.iterator().next());
    }

    private <T extends Service> Collection<T> findServices(Class<T> serviceType, ServiceCreationConfiguration<T> config, boolean shouldCreate) {
        Collection<T> registeredServices = this.getServicesOfTypeInternal(serviceType);
        if (shouldCreate && (registeredServices.isEmpty() || serviceType.isAnnotationPresent(PluralService.class))) {
            registeredServices.addAll(this.discoverServices(serviceType, config));
        }
        return registeredServices;
    }

    public static <T> Collection<T> findAmongst(Class<T> clazz, Collection<?> instances) {
        return ServiceLocator.findAmongst(clazz, instances.toArray());
    }

    public static <T> Collection<T> findAmongst(Class<T> clazz, Object ... instances) {
        ArrayList<T> matches = new ArrayList<T>();
        for (Object instance : instances) {
            if (instance == null || !clazz.isAssignableFrom(instance.getClass())) continue;
            matches.add(clazz.cast(instance));
        }
        return Collections.unmodifiableCollection(matches);
    }

    public static <T> T findSingletonAmongst(Class<T> clazz, Collection<?> instances) {
        return ServiceLocator.findSingletonAmongst(clazz, instances.toArray());
    }

    public static <T> T findSingletonAmongst(Class<T> clazz, Object ... instances) {
        Collection<T> matches = ServiceLocator.findAmongst(clazz, instances);
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return matches.iterator().next();
        }
        throw new IllegalArgumentException("More than one " + clazz.getName() + " found");
    }

    public void startAllServices() throws Exception {
        ArrayDeque<Service> started = new ArrayDeque<Service>();
        Lock lock = this.runningLock.writeLock();
        lock.lock();
        try {
            this.resolveMissingDependencies();
            if (!this.running.compareAndSet(false, true)) {
                throw new IllegalStateException("Already started!");
            }
            for (Set registeredServices : this.services.values()) {
                for (Service service : registeredServices) {
                    if (started.contains(service)) continue;
                    service.start(this);
                    started.push(service);
                }
            }
            LOGGER.debug("All Services successfully started.");
        }
        catch (Exception e) {
            while (!started.isEmpty()) {
                Service toBeStopped = (Service)started.pop();
                try {
                    toBeStopped.stop();
                }
                catch (Exception e1) {
                    LOGGER.error("Stopping Service failed due to ", (Throwable)e1);
                }
            }
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    private void resolveMissingDependencies() {
        for (Set registeredServices : this.services.values()) {
            for (Service service : registeredServices) {
                this.loadDependenciesOf(service.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllServices() throws Exception {
        Exception firstException = null;
        Lock lock = this.runningLock.writeLock();
        lock.lock();
        try {
            if (!this.running.compareAndSet(true, false)) {
                throw new IllegalStateException("Already stopped!");
            }
            Set stoppedServices = Collections.newSetFromMap(new IdentityHashMap());
            for (Set registeredServices : this.services.values()) {
                for (Service service : registeredServices) {
                    if (stoppedServices.contains(service)) continue;
                    try {
                        service.stop();
                    }
                    catch (Exception e) {
                        if (firstException == null) {
                            firstException = e;
                        }
                        LOGGER.error("Stopping Service failed due to ", (Throwable)e);
                    }
                    stoppedServices.add(service);
                }
            }
        }
        finally {
            lock.unlock();
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public void loadDependenciesOf(Class<?> clazz) {
        Collection<Class<? extends Service>> transitiveDependencies = this.identifyTransitiveDependenciesOf(clazz);
        for (Class<? extends Service> aClass : transitiveDependencies) {
            if (!this.findServices(aClass, null, true).isEmpty()) continue;
            throw new IllegalStateException("Unable to resolve dependent service: " + aClass.getName());
        }
    }

    Collection<Class<? extends Service>> identifyTransitiveDependenciesOf(Class<?> clazz) {
        return this.identifyTransitiveDependenciesOf(clazz, new LinkedHashSet<Class<? extends Service>>());
    }

    private Collection<Class<? extends Service>> identifyTransitiveDependenciesOf(Class<?> clazz, Set<Class<? extends Service>> dependencies) {
        if (clazz == null || clazz == Object.class) {
            return dependencies;
        }
        ServiceDependencies annotation = clazz.getAnnotation(ServiceDependencies.class);
        if (annotation != null) {
            for (Class<Service> clazz2 : annotation.value()) {
                if (dependencies.contains(clazz2)) continue;
                if (!Service.class.isAssignableFrom(clazz2)) {
                    throw new IllegalStateException("Service dependency declared by " + clazz.getName() + " is not a Service: " + clazz2.getName());
                }
                dependencies.add(clazz2);
                this.identifyTransitiveDependenciesOf(clazz2, dependencies);
            }
        }
        for (Class<Service> clazz3 : clazz.getInterfaces()) {
            if (Service.class == clazz3 || !Service.class.isAssignableFrom(clazz3)) continue;
            this.identifyTransitiveDependenciesOf(clazz3, dependencies);
        }
        this.identifyTransitiveDependenciesOf(clazz.getSuperclass(), dependencies);
        return dependencies;
    }

    public boolean knowsServiceFor(ServiceConfiguration<?> serviceConfig) {
        return !this.getServicesOfType(serviceConfig.getServiceType()).isEmpty();
    }

    @Override
    public <T extends Service> Collection<T> getServicesOfType(Class<T> serviceType) {
        return this.getServicesOfTypeInternal(serviceType);
    }

    private <T extends Service> Collection<T> getServicesOfTypeInternal(Class<T> serviceType) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        Set registeredServices = (Set)this.services.get(serviceType);
        if (registeredServices != null) {
            for (Service service : registeredServices) {
                result.add(serviceType.cast(service));
            }
        }
        return result;
    }
}

