/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.events;

import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import org.ehcache.ValueSupplier;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.events.StoreEventSink;
import org.ehcache.core.spi.store.events.StoreEventFilter;
import org.ehcache.core.spi.store.events.StoreEventListener;
import org.ehcache.impl.internal.events.CloseableStoreEventSink;
import org.ehcache.impl.internal.events.FireableStoreEventHolder;

abstract class AbstractStoreEventDispatcher<K, V>
implements StoreEventDispatcher<K, V> {
    protected static final StoreEventSink NO_OP_EVENT_SINK = new CloseableStoreEventSink(){

        @Override
        public void close() {
        }

        @Override
        public void closeOnFailure() {
        }

        @Override
        public void reset() {
        }

        @Override
        public void removed(Object key, ValueSupplier value) {
        }

        @Override
        public void updated(Object key, ValueSupplier oldValue, Object newValue) {
        }

        @Override
        public void expired(Object key, ValueSupplier value) {
        }

        @Override
        public void created(Object key, Object value) {
        }

        @Override
        public void evicted(Object key, ValueSupplier value) {
        }
    };
    private final Set<StoreEventFilter<K, V>> filters = new CopyOnWriteArraySet<StoreEventFilter<K, V>>();
    private final Set<StoreEventListener<K, V>> listeners = new CopyOnWriteArraySet<StoreEventListener<K, V>>();
    private final BlockingQueue<FireableStoreEventHolder<K, V>>[] orderedQueues;
    private volatile boolean ordered = false;

    protected AbstractStoreEventDispatcher(int dispatcherConcurrency) {
        if (dispatcherConcurrency <= 0) {
            throw new IllegalArgumentException("Dispatcher concurrency must be an integer greater than 0");
        }
        this.orderedQueues = new LinkedBlockingQueue[dispatcherConcurrency];
        for (int i = 0; i < this.orderedQueues.length; ++i) {
            this.orderedQueues[i] = new LinkedBlockingQueue<FireableStoreEventHolder<K, V>>(10000);
        }
    }

    protected Set<StoreEventListener<K, V>> getListeners() {
        return this.listeners;
    }

    protected Set<StoreEventFilter<K, V>> getFilters() {
        return this.filters;
    }

    protected BlockingQueue<FireableStoreEventHolder<K, V>>[] getOrderedQueues() {
        return this.orderedQueues;
    }

    @Override
    public void addEventListener(StoreEventListener<K, V> eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void removeEventListener(StoreEventListener<K, V> eventListener) {
        this.listeners.remove(eventListener);
    }

    @Override
    public void addEventFilter(StoreEventFilter<K, V> eventFilter) {
        this.filters.add(eventFilter);
    }

    @Override
    public void setEventOrdering(boolean ordering) {
        this.ordered = ordering;
    }

    @Override
    public boolean isEventOrdering() {
        return this.ordered;
    }

    @Override
    public void releaseEventSink(StoreEventSink<K, V> eventSink) {
        ((CloseableStoreEventSink)eventSink).close();
    }

    @Override
    public void releaseEventSinkAfterFailure(StoreEventSink<K, V> eventSink, Throwable throwable) {
        ((CloseableStoreEventSink)eventSink).closeOnFailure();
    }

    @Override
    public void reset(StoreEventSink<K, V> eventSink) {
        ((CloseableStoreEventSink)eventSink).reset();
    }
}

