/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourceType;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.internal.util.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.store.tiering.LowerCachingTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.impl.internal.events.NullStoreEventDispatcher;
import org.ehcache.impl.internal.events.ThreadLocalStoreEventDispatcher;
import org.ehcache.impl.internal.store.offheap.AbstractOffHeapStore;
import org.ehcache.impl.internal.store.offheap.EhcacheConcurrentOffHeapClockCache;
import org.ehcache.impl.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.ehcache.impl.internal.store.offheap.HeuristicConfiguration;
import org.ehcache.impl.internal.store.offheap.OffHeapStoreUtils;
import org.ehcache.impl.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.impl.internal.store.offheap.SwitchableEvictionAdvisor;
import org.ehcache.impl.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.ehcache.impl.internal.store.offheap.portability.OffHeapValueHolderPortability;
import org.ehcache.impl.internal.store.offheap.portability.SerializerPortability;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.paging.UpfrontAllocatingPageSource;
import org.terracotta.offheapstore.storage.OffHeapBufferStorageEngine;
import org.terracotta.offheapstore.storage.PointerSize;
import org.terracotta.offheapstore.util.Factory;
import org.terracotta.statistics.StatisticsManager;

public class OffHeapStore<K, V>
extends AbstractOffHeapStore<K, V> {
    private final SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final long sizeInBytes;
    private volatile EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> map;

    public OffHeapStore(Store.Configuration<K, V> config, TimeSource timeSource, StoreEventDispatcher<K, V> eventDispatcher, long sizeInBytes) {
        super("local-offheap", config, timeSource, eventDispatcher);
        EvictionAdvisor<K, V> evictionAdvisor = config.getEvictionAdvisor();
        this.evictionAdvisor = evictionAdvisor != null ? OffHeapStore.wrap(evictionAdvisor) : OffHeapStore.wrap(Eviction.noAdvice());
        this.keySerializer = config.getKeySerializer();
        this.valueSerializer = config.getValueSerializer();
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return Collections.emptyList();
    }

    private EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> createBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor) {
        HeuristicConfiguration config = new HeuristicConfiguration(size);
        UpfrontAllocatingPageSource source = new UpfrontAllocatingPageSource(OffHeapStoreUtils.getBufferSource(), config.getMaximumSize(), config.getMaximumChunkSize(), config.getMinimumChunkSize());
        SerializerPortability<K> keyPortability = new SerializerPortability<K>(keySerializer);
        OffHeapValueHolderPortability<V> elementPortability = new OffHeapValueHolderPortability<V>(valueSerializer);
        Factory<OffHeapBufferStorageEngine<K, V>> storageEngineFactory = OffHeapBufferStorageEngine.createFactory(PointerSize.INT, source, config.getSegmentDataPageSize(), keyPortability, elementPortability, false, true);
        EhcacheSegmentFactory<K, OffHeapValueHolder<V>> segmentFactory = new EhcacheSegmentFactory<K, OffHeapValueHolder<V>>(source, storageEngineFactory, config.getInitialSegmentTableSize(), evictionAdvisor, this.mapEvictionListener);
        return new EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>>(evictionAdvisor, segmentFactory, config.getConcurrency());
    }

    @Override
    protected EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>> backingMap() {
        return this.map;
    }

    @Override
    protected SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor() {
        return this.evictionAdvisor;
    }

    @ServiceDependencies(value={TimeSourceService.class, SerializationProvider.class})
    public static class Provider
    implements Store.Provider,
    AuthoritativeTier.Provider,
    LowerCachingTier.Provider {
        private static final Logger LOGGER = LoggerFactory.getLogger(Provider.class);
        private volatile ServiceProvider<Service> serviceProvider;
        private final Set<Store<?, ?>> createdStores = Collections.newSetFromMap(new ConcurrentWeakIdentityHashMap());

        @Override
        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
            return ((Object)resourceTypes).equals(Collections.singleton(ResourceType.Core.OFFHEAP)) ? 1 : 0;
        }

        @Override
        public int rankAuthority(ResourceType<?> authorityResource, Collection<ServiceConfiguration<?>> serviceConfigs) {
            return authorityResource.equals(ResourceType.Core.OFFHEAP) ? 1 : 0;
        }

        public <K, V> OffHeapStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStoreInternal(storeConfig, new ThreadLocalStoreEventDispatcher(storeConfig.getDispatcherConcurrency()), serviceConfigs);
        }

        private <K, V> OffHeapStore<K, V> createStoreInternal(Store.Configuration<K, V> storeConfig, StoreEventDispatcher<K, V> eventDispatcher, ServiceConfiguration<?> ... serviceConfigs) {
            if (this.serviceProvider == null) {
                throw new NullPointerException("ServiceProvider is null in OffHeapStore.Provider.");
            }
            TimeSource timeSource = this.serviceProvider.getService(TimeSourceService.class).getTimeSource();
            SizedResourcePool offHeapPool = storeConfig.getResourcePools().getPoolForResource(ResourceType.Core.OFFHEAP);
            if (!(offHeapPool.getUnit() instanceof MemoryUnit)) {
                throw new IllegalArgumentException("OffHeapStore only supports resources with memory unit");
            }
            MemoryUnit unit = (MemoryUnit)offHeapPool.getUnit();
            OffHeapStore<K, V> offHeapStore = new OffHeapStore<K, V>(storeConfig, timeSource, eventDispatcher, unit.toBytes(offHeapPool.getSize()));
            this.createdStores.add(offHeapStore);
            return offHeapStore;
        }

        @Override
        public void releaseStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            Provider.close((OffHeapStore)resource);
        }

        static void close(OffHeapStore resource) {
            EhcacheConcurrentOffHeapClockCache localMap = resource.map;
            if (localMap != null) {
                resource.map = null;
                localMap.destroy();
            }
            StatisticsManager.dissociate(resource.offHeapStoreStatsSettings).fromParent(resource);
        }

        @Override
        public void initStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            Provider.init((OffHeapStore)resource);
        }

        static <K, V> void init(OffHeapStore<K, V> resource) {
            ((OffHeapStore)resource).map = ((OffHeapStore)resource).createBackingMap(((OffHeapStore)resource).sizeInBytes, ((OffHeapStore)resource).keySerializer, ((OffHeapStore)resource).valueSerializer, ((OffHeapStore)resource).evictionAdvisor);
        }

        @Override
        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        @Override
        public void stop() {
            this.serviceProvider = null;
            this.createdStores.clear();
        }

        @Override
        public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore((Store.Configuration)storeConfig, (ServiceConfiguration[])serviceConfigs);
        }

        @Override
        public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.releaseStore(resource);
        }

        @Override
        public void initAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.initStore(resource);
        }

        @Override
        public <K, V> LowerCachingTier<K, V> createCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStoreInternal(storeConfig, NullStoreEventDispatcher.nullStoreEventDispatcher(), serviceConfigs);
        }

        @Override
        public void releaseCachingTier(LowerCachingTier<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            this.flushToLowerTier((OffHeapStore)resource);
            this.releaseStore((Store)((Object)resource));
        }

        private void flushToLowerTier(OffHeapStore<Object, ?> resource) {
            StoreAccessException lastFailure = null;
            int failureCount = 0;
            OffHeapStore<Object, ?> offheapStore = resource;
            Set keys = offheapStore.backingMap().keySet();
            for (Object key : keys) {
                try {
                    offheapStore.invalidate(key);
                }
                catch (StoreAccessException cae) {
                    lastFailure = cae;
                    ++failureCount;
                    LOGGER.warn("Error flushing '{}' to lower tier", key, (Object)cae);
                }
            }
            if (lastFailure != null) {
                throw new RuntimeException("Failed to flush some mappings to lower tier, " + failureCount + " could not be flushed. This error represents the last failure.", lastFailure);
            }
        }

        @Override
        public void initCachingTier(LowerCachingTier<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            this.initStore((Store)((Object)resource));
        }
    }
}

