/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ehcache.impl.internal.util.ByteBufferInputStream;
import org.ehcache.impl.serialization.TransientStateRepository;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;

public class CompactJavaSerializer<T>
implements Serializer<T> {
    private final ConcurrentMap<Integer, ObjectStreamClass> readLookup;
    private final ConcurrentMap<Integer, ObjectStreamClass> readLookupLocalCache = new ConcurrentHashMap<Integer, ObjectStreamClass>();
    private final ConcurrentMap<SerializableDataKey, Integer> writeLookup = new ConcurrentHashMap<SerializableDataKey, Integer>();
    private final Lock lock = new ReentrantLock();
    private int nextStreamIndex = 0;
    private final transient ClassLoader loader;

    public CompactJavaSerializer(ClassLoader loader) {
        this(loader, new TransientStateRepository());
    }

    public CompactJavaSerializer(ClassLoader loader, StateRepository stateRepository) {
        this.loader = loader;
        this.readLookup = stateRepository.getPersistentConcurrentMap("CompactJavaSerializer-ObjectStreamClassIndex", Integer.class, ObjectStreamClass.class);
        this.loadMappingsInWriteContext(this.readLookup.entrySet(), true);
    }

    CompactJavaSerializer(ClassLoader loader, Map<Integer, ObjectStreamClass> mappings) {
        this(loader);
        for (Map.Entry<Integer, ObjectStreamClass> e : mappings.entrySet()) {
            Integer encoding = e.getKey();
            ObjectStreamClass disconnectedOsc = CompactJavaSerializer.disconnect(e.getValue());
            this.readLookup.put(encoding, disconnectedOsc);
            this.readLookupLocalCache.put(encoding, disconnectedOsc);
            if (this.writeLookup.putIfAbsent(new SerializableDataKey(disconnectedOsc, true), encoding) != null) {
                throw new AssertionError((Object)("Corrupted data " + mappings));
            }
            if (this.nextStreamIndex >= encoding + 1) continue;
            this.nextStreamIndex = encoding + 1;
        }
    }

    Map<Integer, ObjectStreamClass> getSerializationMappings() {
        return Collections.unmodifiableMap(new HashMap<Integer, ObjectStreamClass>(this.readLookup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer serialize(T object) throws SerializerException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = this.getObjectOutputStream(bout);
            try {
                oout.writeObject(object);
            }
            finally {
                oout.close();
            }
            return ByteBuffer.wrap(bout.toByteArray());
        }
        catch (IOException e) {
            throw new SerializerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T read(ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        try {
            ObjectInputStream oin = this.getObjectInputStream(new ByteBufferInputStream(binary));
            try {
                Object object = oin.readObject();
                return (T)object;
            }
            finally {
                oin.close();
            }
        }
        catch (IOException e) {
            throw new SerializerException(e);
        }
    }

    private ObjectOutputStream getObjectOutputStream(OutputStream out) throws IOException {
        return new OOS(out);
    }

    private ObjectInputStream getObjectInputStream(InputStream input) throws IOException {
        return new OIS(input, this.loader);
    }

    @Override
    public boolean equals(T object, ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        return object.equals(this.read(binary));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOrAddMapping(ObjectStreamClass desc) throws IOException {
        SerializableDataKey probe = new SerializableDataKey(desc, false);
        Integer rep = (Integer)this.writeLookup.get(probe);
        if (rep != null) {
            return rep;
        }
        this.lock.lock();
        try {
            int n = this.addMappingUnderLock(desc, probe);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int addMappingUnderLock(ObjectStreamClass desc, SerializableDataKey probe) throws IOException {
        ObjectStreamClass disconnected = CompactJavaSerializer.disconnect(desc);
        SerializableDataKey key = new SerializableDataKey(disconnected, true);
        Integer rep;
        while ((rep = (Integer)this.writeLookup.get(probe)) == null) {
            ObjectStreamClass existingOsc;
            if ((existingOsc = this.readLookup.putIfAbsent(rep = Integer.valueOf(this.nextStreamIndex++), disconnected)) == null) {
                this.writeLookup.put(key, rep);
                this.readLookupLocalCache.put(rep, disconnected);
                return rep;
            }
            ObjectStreamClass discOsc = CompactJavaSerializer.disconnect(existingOsc);
            this.writeLookup.put(new SerializableDataKey(discOsc, true), rep);
            this.readLookupLocalCache.put(rep, discOsc);
        }
        return rep;
    }

    private void loadMappingsInWriteContext(Set<Map.Entry<Integer, ObjectStreamClass>> entries, boolean throwOnFailedPutIfAbsent) {
        for (Map.Entry<Integer, ObjectStreamClass> entry : entries) {
            Integer index = entry.getKey();
            ObjectStreamClass discOsc = CompactJavaSerializer.disconnect(entry.getValue());
            this.readLookupLocalCache.put(index, discOsc);
            if (this.writeLookup.putIfAbsent(new SerializableDataKey(discOsc, true), index) != null && throwOnFailedPutIfAbsent) {
                throw new AssertionError((Object)("Corrupted data " + this.readLookup));
            }
            if (this.nextStreamIndex >= index + 1) continue;
            this.nextStreamIndex = index + 1;
        }
    }

    private static boolean equals(SerializableDataKey k1, SerializableDataKey k2) {
        Class<?> k1Clazz = k1.forClass();
        Class<?> k2Clazz = k2.forClass();
        if (k1Clazz != null && k2Clazz != null) {
            return k1Clazz == k2Clazz;
        }
        if (CompactJavaSerializer.equals(k1.getObjectStreamClass(), k2.getObjectStreamClass())) {
            if (k1Clazz != null) {
                k2.setClass(k1Clazz);
            } else if (k2Clazz != null) {
                k1.setClass(k2Clazz);
            }
            return true;
        }
        return false;
    }

    private static boolean equals(ObjectStreamClass osc1, ObjectStreamClass osc2) {
        if (osc1 == osc2) {
            return true;
        }
        if (osc1.getName().equals(osc2.getName()) && osc1.getSerialVersionUID() == osc2.getSerialVersionUID() && osc1.getFields().length == osc2.getFields().length) {
            try {
                return Arrays.equals(CompactJavaSerializer.getSerializedForm(osc1), CompactJavaSerializer.getSerializedForm(osc2));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return false;
    }

    private static ObjectStreamClass disconnect(ObjectStreamClass desc) {
        try {
            ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(CompactJavaSerializer.getSerializedForm(desc))){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass osc) {
                    return null;
                }
            };
            return (ObjectStreamClass)oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getSerializedForm(ObjectStreamClass desc) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            try {
                oout.writeObject(desc);
            }
            finally {
                oout.close();
            }
        }
        finally {
            bout.close();
        }
        return bout.toByteArray();
    }

    private static class SerializableDataKey {
        private final ObjectStreamClass osc;
        private final int hashCode;
        private transient WeakReference<Class<?>> klazz;

        SerializableDataKey(ObjectStreamClass desc, boolean store) {
            Class<?> forClass = desc.forClass();
            if (forClass != null) {
                if (store) {
                    throw new AssertionError((Object)"Must not store ObjectStreamClass instances with strong references to classes");
                }
                if (ObjectStreamClass.lookup(forClass) == desc) {
                    this.klazz = new WeakReference(forClass);
                }
            }
            this.hashCode = 3 * desc.getName().hashCode() ^ 7 * (int)(desc.getSerialVersionUID() >>> 32) ^ 11 * (int)desc.getSerialVersionUID();
            this.osc = desc;
        }

        public boolean equals(Object o) {
            if (o instanceof SerializableDataKey) {
                return CompactJavaSerializer.equals(this, (SerializableDataKey)o);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        Class<?> forClass() {
            if (this.klazz == null) {
                return null;
            }
            return (Class)this.klazz.get();
        }

        public void setClass(Class<?> clazz) {
            this.klazz = new WeakReference(clazz);
        }

        ObjectStreamClass getObjectStreamClass() {
            return this.osc;
        }
    }

    class OIS
    extends ObjectInputStream {
        private final ClassLoader loader;

        OIS(InputStream in, ClassLoader loader) throws IOException {
            super(in);
            this.loader = loader;
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            int key = this.readInt();
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)CompactJavaSerializer.this.readLookupLocalCache.get(key);
            if (objectStreamClass != null) {
                return objectStreamClass;
            }
            objectStreamClass = (ObjectStreamClass)CompactJavaSerializer.this.readLookup.get(key);
            ObjectStreamClass discOsc = CompactJavaSerializer.disconnect(objectStreamClass);
            CompactJavaSerializer.this.readLookupLocalCache.put(key, discOsc);
            CompactJavaSerializer.this.writeLookup.putIfAbsent(new SerializableDataKey(discOsc, true), key);
            return objectStreamClass;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                ClassLoader cl;
                ClassLoader classLoader = cl = this.loader == null ? Thread.currentThread().getContextClassLoader() : this.loader;
                if (cl == null) {
                    return super.resolveClass(desc);
                }
                try {
                    return Class.forName(desc.getName(), false, cl);
                }
                catch (ClassNotFoundException e) {
                    return super.resolveClass(desc);
                }
            }
            catch (SecurityException ex) {
                return super.resolveClass(desc);
            }
        }
    }

    class OOS
    extends ObjectOutputStream {
        OOS(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            this.writeInt(CompactJavaSerializer.this.getOrAddMapping(desc));
        }
    }
}

