/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.impl.internal.util.ByteBufferInputStream;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;

public class PlainJavaSerializer<T>
implements Serializer<T> {
    private final ClassLoader classLoader;

    public PlainJavaSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public PlainJavaSerializer(ClassLoader classLoader, StateRepository stateRepository) throws IOException, ClassNotFoundException {
        this(classLoader);
    }

    @Override
    public ByteBuffer serialize(T object) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(object);
        }
        catch (IOException e) {
            throw new SerializerException(e);
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return ByteBuffer.wrap(bout.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(ByteBuffer entry) throws SerializerException, ClassNotFoundException {
        ByteBufferInputStream bin = new ByteBufferInputStream(entry);
        try {
            Object object;
            OIS ois = new OIS(bin, this.classLoader);
            try {
                object = ois.readObject();
            }
            catch (Throwable throwable) {
                try {
                    ois.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SerializerException(e);
                }
            }
            ois.close();
            return (T)object;
        }
        finally {
            try {
                bin.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public boolean equals(T object, ByteBuffer binary) throws SerializerException, ClassNotFoundException {
        return object.equals(this.read(binary));
    }

    private static class OIS
    extends ObjectInputStream {
        private final ClassLoader classLoader;
        private static final Map<String, Class<?>> primitiveClasses = new HashMap();

        public OIS(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(desc.getName(), false, this.classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                Class<?> primitive = primitiveClasses.get(desc.getName());
                if (primitive != null) {
                    return primitive;
                }
                throw cnfe;
            }
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            Class[] interfaceClasses = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                interfaceClasses[i] = Class.forName(interfaces[i], false, this.classLoader);
            }
            return Proxy.getProxyClass(this.classLoader, interfaceClasses);
        }

        static {
            primitiveClasses.put("boolean", Boolean.TYPE);
            primitiveClasses.put("byte", Byte.TYPE);
            primitiveClasses.put("char", Character.TYPE);
            primitiveClasses.put("double", Double.TYPE);
            primitiveClasses.put("float", Float.TYPE);
            primitiveClasses.put("int", Integer.TYPE);
            primitiveClasses.put("long", Long.TYPE);
            primitiveClasses.put("short", Short.TYPE);
            primitiveClasses.put("void", Void.TYPE);
        }
    }
}

