/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.context.extended;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.terracotta.context.annotations.ContextAttribute;

public class ExposedStatistic {
    @ContextAttribute(value="name")
    private final String name;
    @ContextAttribute(value="type")
    private final Class<?> type;
    @ContextAttribute(value="tags")
    private final Set<String> tags;
    @ContextAttribute(value="properties")
    private final Map<String, Object> properties;
    @ContextAttribute(value="this")
    private final Object stat;

    public ExposedStatistic(String name, Class<?> type, Set<String> tags, Map<String, Object> properties, Object stat) {
        this.name = name;
        this.type = type;
        this.tags = ExposedStatistic.exposedTags(tags);
        this.properties = properties == null ? Collections.emptyMap() : properties;
        this.stat = stat;
    }

    private static Set<String> exposedTags(Set<String> tags) {
        HashSet<String> allTags = new HashSet<String>(tags);
        allTags.add("exposed");
        return allTags;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getStat() {
        return this.stat;
    }
}

