/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.context.extended;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.terracotta.context.ContextManager;
import org.terracotta.context.TreeNode;
import org.terracotta.context.extended.ExposedStatistic;
import org.terracotta.context.extended.OperationType;
import org.terracotta.context.query.Matcher;
import org.terracotta.context.query.Matchers;
import org.terracotta.context.query.Query;
import org.terracotta.context.query.QueryBuilder;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.Time;
import org.terracotta.statistics.extended.CompoundOperation;
import org.terracotta.statistics.extended.CompoundOperationImpl;
import org.terracotta.statistics.extended.CountOperation;
import org.terracotta.statistics.extended.NullCompoundOperation;
import org.terracotta.statistics.extended.Result;
import org.terracotta.statistics.extended.SampledStatistic;

public class StatisticsRegistry {
    private final Class<? extends OperationType> operationTypeClazz;
    private final Object contextObject;
    private final ConcurrentMap<OperationType, CompoundOperation<?>> standardOperations = new ConcurrentHashMap();
    private final ScheduledExecutorService executor;
    private final Runnable disableTask;
    private volatile long timeToDisable;
    private volatile TimeUnit timeToDisableUnit;
    private volatile ScheduledFuture<?> disableStatus;
    private final long averageWindowDuration;
    private final TimeUnit averageWindowUnit;
    private final int historySize;
    private final long historyInterval;
    private final TimeUnit historyIntervalUnit;
    private final List<ExposedStatistic> registrations = new CopyOnWriteArrayList<ExposedStatistic>();

    public StatisticsRegistry(Class<? extends OperationType> operationTypeClazz, Object contextObject, ScheduledExecutorService executor, long averageWindowDuration, TimeUnit averageWindowUnit, int historySize, long historyInterval, TimeUnit historyIntervalUnit, long timeToDisable, TimeUnit timeToDisableUnit) {
        if (!operationTypeClazz.isEnum()) {
            throw new IllegalArgumentException("StatisticsRegistry operationTypeClazz must be enum");
        }
        this.operationTypeClazz = operationTypeClazz;
        this.contextObject = contextObject;
        this.averageWindowDuration = averageWindowDuration;
        this.averageWindowUnit = averageWindowUnit;
        this.historySize = historySize;
        this.historyInterval = historyInterval;
        this.historyIntervalUnit = historyIntervalUnit;
        this.executor = executor;
        this.timeToDisable = timeToDisable;
        this.timeToDisableUnit = timeToDisableUnit;
        this.disableTask = this.createDisableTask();
        this.disableStatus = this.executor.scheduleAtFixedRate(this.disableTask, timeToDisable, timeToDisable, timeToDisableUnit);
        this.discoverOperationObservers();
    }

    private Runnable createDisableTask() {
        return new Runnable(){

            @Override
            public void run() {
                long expireThreshold = Time.absoluteTime() - StatisticsRegistry.this.timeToDisableUnit.toMillis(StatisticsRegistry.this.timeToDisable);
                for (CompoundOperation o : StatisticsRegistry.this.standardOperations.values()) {
                    if (!(o instanceof CompoundOperationImpl)) continue;
                    ((CompoundOperationImpl)o).expire(expireThreshold);
                }
            }
        };
    }

    public synchronized void setTimeToDisable(long time, TimeUnit unit) {
        this.timeToDisable = time;
        this.timeToDisableUnit = unit;
        if (this.disableStatus != null) {
            this.disableStatus.cancel(false);
            this.disableStatus = this.executor.scheduleAtFixedRate(this.disableTask, this.timeToDisable, this.timeToDisable, this.timeToDisableUnit);
        }
    }

    public synchronized void setAlwaysOn(boolean enabled) {
        if (enabled) {
            if (this.disableStatus != null) {
                this.disableStatus.cancel(false);
                this.disableStatus = null;
            }
            for (CompoundOperation o : this.standardOperations.values()) {
                o.setAlwaysOn(true);
            }
        } else {
            if (this.disableStatus == null) {
                this.disableStatus = this.executor.scheduleAtFixedRate(this.disableTask, 0L, this.timeToDisable, this.timeToDisableUnit);
            }
            for (CompoundOperation o : this.standardOperations.values()) {
                o.setAlwaysOn(false);
            }
        }
    }

    public void registerCompoundOperation(String name, Set<String> tags, Map<String, Object> properties, OperationType operationType, Set<?> operations) {
        Result result = this.getCompoundOperation(operationType).compound(operations);
        ExposedStatistic exposedStatistic = new ExposedStatistic(name, operationType.type(), tags, properties, result);
        this.registrations.add(exposedStatistic);
    }

    public void registerCountOperation(String name, Set<String> tags, Map<String, Object> properties, OperationType operationType) {
        CountOperation<?> countOperation = this.getCompoundOperation(operationType).asCountOperation();
        ExposedStatistic exposedStatistic = new ExposedStatistic(name, operationType.type(), tags, properties, countOperation);
        this.registrations.add(exposedStatistic);
    }

    public void registerRatio(String name, Set<String> tags, Map<String, Object> properties, OperationType operationType, Set<?> numerator, Set<?> denominator) {
        SampledStatistic<Double> ratio = this.getCompoundOperation(operationType).ratioOf(numerator, denominator);
        ExposedStatistic exposedStatistic = new ExposedStatistic(name, operationType.type(), tags, properties, ratio);
        this.registrations.add(exposedStatistic);
    }

    public Collection<ExposedStatistic> getRegistrations() {
        return Collections.unmodifiableCollection(this.registrations);
    }

    public void clearRegistrations() {
        this.registrations.clear();
    }

    private CompoundOperation<?> getCompoundOperation(OperationType operationType) {
        CompoundOperation operation = (CompoundOperation)this.standardOperations.get(operationType);
        if (operation instanceof NullCompoundOperation) {
            OperationStatistic discovered = this.findOperationObserver(operationType);
            if (discovered == null) {
                return operation;
            }
            CompoundOperationImpl newOperation = new CompoundOperationImpl(discovered, operationType.type(), this.averageWindowDuration, this.averageWindowUnit, this.executor, this.historySize, this.historyInterval, this.historyIntervalUnit);
            if (this.standardOperations.replace(operationType, operation, newOperation)) {
                return newOperation;
            }
            return (CompoundOperation)this.standardOperations.get(operationType);
        }
        return operation;
    }

    private void discoverOperationObservers() {
        for (OperationType t : this.operationTypeClazz.getEnumConstants()) {
            OperationStatistic statistic = this.findOperationObserver(t);
            if (statistic == null) {
                if (t.required()) {
                    throw new IllegalStateException("Required statistic " + t + " not found");
                }
                Class<? extends Enum<?>> type = t.type();
                CompoundOperation<? extends Enum<?>> compoundOperation = NullCompoundOperation.instance(type);
                this.standardOperations.put(t, compoundOperation);
                continue;
            }
            CompoundOperationImpl compoundOperation = new CompoundOperationImpl(statistic, t.type(), this.averageWindowDuration, this.averageWindowUnit, this.executor, this.historySize, this.historyInterval, this.historyIntervalUnit);
            this.standardOperations.put(t, compoundOperation);
        }
    }

    private OperationStatistic findOperationObserver(OperationType statistic) {
        Set<OperationStatistic<?>> results = this.findOperationObserver(statistic.context(), statistic.type(), statistic.operationName(), statistic.tags());
        switch (results.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return results.iterator().next();
            }
        }
        throw new IllegalStateException("Duplicate statistics found for " + statistic);
    }

    private Set<OperationStatistic<?>> findOperationObserver(Query contextQuery, Class<?> type, String name, final Set<String> tags) {
        Query q = QueryBuilder.queryBuilder().chain(contextQuery).children().filter(Matchers.context(Matchers.identifier(Matchers.subclassOf(OperationStatistic.class)))).build();
        Set<TreeNode> operationStatisticNodes = q.execute(Collections.singleton(ContextManager.nodeFor(this.contextObject)));
        Set<TreeNode> result = QueryBuilder.queryBuilder().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("type", type), Matchers.hasAttribute("name", name), Matchers.hasAttribute("tags", (Matcher<? extends Object>)new Matcher<Set<String>>(){

            @Override
            protected boolean matchesSafely(Set<String> object) {
                return object.containsAll(tags);
            }
        }))))).build().execute(operationStatisticNodes);
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet statistics = new HashSet();
        for (TreeNode node : result) {
            statistics.add((OperationStatistic)node.getContext().attributes().get("this"));
        }
        return statistics;
    }
}

