/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.util.KotlinSuspendingFunctionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="1.13.3")
public class KotlinReflectionUtils {
    private static final String DEFAULT_IMPLS_CLASS_NAME = "DefaultImpls";
    private static final @Nullable Class<? extends Annotation> kotlinMetadata;
    private static final @Nullable Class<?> kotlinCoroutineContinuation;
    private static final boolean kotlinReflectPresent;
    private static final boolean kotlinxCoroutinesPresent;

    private static Try<Class<? extends Annotation>> tryToLoadKotlinMetadataClass() {
        return ReflectionUtils.tryToLoadClass("kotlin.Metadata").andThenTry(it -> it);
    }

    @API(status=API.Status.INTERNAL, since="6.0")
    public static boolean isKotlinSuspendingFunction(Method method) {
        if (kotlinCoroutineContinuation != null && KotlinReflectionUtils.isKotlinType(method.getDeclaringClass())) {
            int parameterCount = method.getParameterCount();
            return parameterCount > 0 && method.getParameterTypes()[parameterCount - 1] == kotlinCoroutineContinuation;
        }
        return false;
    }

    public static boolean isKotlinInterfaceDefaultImplsClass(Class<?> clazz) {
        if (!(KotlinReflectionUtils.isKotlinType(clazz) && DEFAULT_IMPLS_CLASS_NAME.equals(clazz.getSimpleName()) && ReflectionUtils.isStatic(clazz))) {
            return false;
        }
        Class<?> enclosingClass = clazz.getEnclosingClass();
        if (enclosingClass != null && enclosingClass.isInterface()) {
            return Arrays.stream(clazz.getDeclaredMethods()).anyMatch(method -> KotlinReflectionUtils.isCompilerGeneratedDefaultMethod(method, enclosingClass));
        }
        return false;
    }

    private static boolean isCompilerGeneratedDefaultMethod(Method method, Class<?> enclosingClass) {
        Class<?>[] parameterTypes;
        if (ReflectionUtils.isStatic(method) && method.getParameterCount() > 0 && (parameterTypes = method.getParameterTypes())[0] == enclosingClass) {
            Class<?>[] originalParameterTypes = KotlinReflectionUtils.copyWithoutFirst(parameterTypes);
            return ReflectionUtils.findMethod(enclosingClass, method.getName(), originalParameterTypes).isPresent();
        }
        return false;
    }

    private static Class<?>[] copyWithoutFirst(Class<?>[] values) {
        if (values.length == 1) {
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] result = new Class[values.length - 1];
        System.arraycopy(values, 1, result, 0, result.length);
        return result;
    }

    private static boolean isKotlinType(Class<?> clazz) {
        return kotlinMetadata != null && clazz.getDeclaredAnnotation(kotlinMetadata) != null;
    }

    public static Class<?> getKotlinSuspendingFunctionReturnType(Method method) {
        KotlinReflectionUtils.requireKotlinReflect(method);
        return KotlinSuspendingFunctionUtils.getReturnType(method);
    }

    public static Type getKotlinSuspendingFunctionGenericReturnType(Method method) {
        KotlinReflectionUtils.requireKotlinReflect(method);
        return KotlinSuspendingFunctionUtils.getGenericReturnType(method);
    }

    public static Parameter[] getKotlinSuspendingFunctionParameters(Method method) {
        KotlinReflectionUtils.requireKotlinReflect(method);
        return KotlinSuspendingFunctionUtils.getParameters(method);
    }

    public static Class<?>[] getKotlinSuspendingFunctionParameterTypes(Method method) {
        KotlinReflectionUtils.requireKotlinReflect(method);
        return KotlinSuspendingFunctionUtils.getParameterTypes(method);
    }

    public static @Nullable Object invokeKotlinSuspendingFunction(Method method, @Nullable Object target, @Nullable Object[] args) {
        KotlinReflectionUtils.requireKotlinReflect(method);
        KotlinReflectionUtils.requireKotlinxCoroutines(method);
        return KotlinSuspendingFunctionUtils.invoke(method, target, args);
    }

    private static void requireKotlinReflect(Method method) {
        KotlinReflectionUtils.requireDependency(method, kotlinReflectPresent, "org.jetbrains.kotlin:kotlin-reflect");
    }

    private static void requireKotlinxCoroutines(Method method) {
        KotlinReflectionUtils.requireDependency(method, kotlinxCoroutinesPresent, "org.jetbrains.kotlinx:kotlinx-coroutines-core");
    }

    private static void requireDependency(Method method, boolean condition, String dependencyNotation) {
        Preconditions.condition(condition, () -> "Kotlin suspending function [%s] requires %s to be on the classpath or module path. Please add a corresponding dependency.".formatted(method.toGenericString(), dependencyNotation));
    }

    private KotlinReflectionUtils() {
    }

    static {
        Try<Class<? extends Annotation>> metadata = KotlinReflectionUtils.tryToLoadKotlinMetadataClass();
        kotlinMetadata = metadata.toOptional().orElse(null);
        kotlinCoroutineContinuation = metadata.andThen(__ -> ReflectionUtils.tryToLoadClass("kotlin.coroutines.Continuation")).toOptional().orElse(null);
        kotlinReflectPresent = metadata.andThen(__ -> ReflectionUtils.tryToLoadClass("kotlin.reflect.jvm.ReflectJvmMapping")).toOptional().isPresent();
        kotlinxCoroutinesPresent = metadata.andThen(__ -> ReflectionUtils.tryToLoadClass("kotlinx.coroutines.BuildersKt")).toOptional().isPresent();
    }
}

